/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import java.util.LinkedHashMap;
import java.util.Map;

public class EntityLocationUtils {
    protected final ManagementContext context;

    public EntityLocationUtils(ManagementContext ctx) {
        this.context = ctx;
    }

    public Map<Location, Integer> countLeafEntitiesByLocatedLocations() {
        LinkedHashMap<Location, Integer> result = new LinkedHashMap<Location, Integer>();
        for (Entity e : this.context.getApplications()) {
            this.countLeafEntitiesByLocatedLocations(e, null, result);
        }
        return result;
    }

    protected void countLeafEntitiesByLocatedLocations(Entity target, Entity locatedParent, Map<Location, Integer> result) {
        block4: {
            block3: {
                if (this.isLocatedLocation(target)) {
                    locatedParent = target;
                }
                if (target.getChildren().isEmpty()) break block3;
                for (Entity child : target.getChildren()) {
                    this.countLeafEntitiesByLocatedLocations(child, locatedParent, result);
                }
                break block4;
            }
            if (locatedParent == null) break block4;
            for (Location l : locatedParent.getLocations()) {
                Location ll = this.getMostGeneralLocatedLocation(l);
                if (ll == null) continue;
                Integer count = result.get(ll);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                result.put(ll, count);
            }
        }
    }

    protected Location getMostGeneralLocatedLocation(Location l) {
        if (l == null) {
            return null;
        }
        if (!this.isLocatedLocation(l)) {
            return null;
        }
        Location ll = this.getMostGeneralLocatedLocation(l.getParentLocation());
        if (ll != null) {
            return ll;
        }
        return l;
    }

    protected boolean isLocatedLocation(Entity target) {
        for (Location l : target.getLocations()) {
            if (!this.isLocatedLocation(l)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLocatedLocation(Location l) {
        return l.getLocationProperty("latitude") != null && l.getLocationProperty("longitude") != null;
    }
}

