/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.util;

import brooklyn.rest.domain.ApiError;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(WebResourceUtils.class);

    public static WebApplicationException notFound(String format, Object ... args) {
        String msg = String.format(format, args);
        if (log.isDebugEnabled()) {
            log.debug("returning 404 notFound(" + msg + ") - may be a stale browser session");
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(msg)).build());
    }

    public static WebApplicationException preconditionFailed(String format, Object ... args) {
        String msg = String.format(format, args);
        if (log.isDebugEnabled()) {
            log.debug("returning 412 preconditionFailed(" + msg + ")");
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(msg)).build());
    }
}

