/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.test;

import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Asserts {
    private static final Logger log = LoggerFactory.getLogger(Asserts.class);

    private Asserts() {
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            Asserts.fail(message);
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static <T> void eventually(Supplier<? extends T> supplier, Predicate<T> predicate) {
        Asserts.eventually(ImmutableMap.of(), supplier, predicate);
    }

    public static <T> void eventually(Map<String, ?> flags, Supplier<? extends T> supplier, Predicate<T> predicate) {
        Asserts.eventually(flags, supplier, predicate, null);
    }

    public static <T> void eventually(Map<String, ?> flags, Supplier<? extends T> supplier, Predicate<T> predicate, String errMsg) {
        Duration timeout = Asserts.toDuration(flags.get("timeout"), Duration.ONE_SECOND);
        Duration period = Asserts.toDuration(flags.get("period"), Duration.millis(10));
        long periodMs = period.toMilliseconds();
        long startTime = System.currentTimeMillis();
        long expireTime = startTime + timeout.toMilliseconds();
        boolean first = true;
        Object supplied = supplier.get();
        while (first || System.currentTimeMillis() <= expireTime) {
            supplied = supplier.get();
            if (predicate.apply(supplied)) {
                return;
            }
            first = false;
            if (periodMs <= 0L) continue;
            Asserts.sleep(periodMs);
        }
        Asserts.fail("supplied=" + supplied + "; predicate=" + predicate + (errMsg != null ? "; " + errMsg : ""));
    }

    public static <T> void continually(Supplier<? extends T> supplier, Predicate<T> predicate) {
        Asserts.continually(ImmutableMap.of(), supplier, predicate);
    }

    public static <T> void continually(Map<String, ?> flags, Supplier<? extends T> supplier, Predicate<? super T> predicate) {
        Asserts.continually(flags, supplier, predicate, null);
    }

    public static <T> void continually(Map<String, ?> flags, Supplier<? extends T> supplier, Predicate<T> predicate, String errMsg) {
        Duration duration = Asserts.toDuration(flags.get("timeout"), Duration.ONE_SECOND);
        Duration period = Asserts.toDuration(flags.get("period"), Duration.millis(10));
        long periodMs = period.toMilliseconds();
        long startTime = System.currentTimeMillis();
        long expireTime = startTime + duration.toMilliseconds();
        boolean first = true;
        while (first || System.currentTimeMillis() <= expireTime) {
            Asserts.assertTrue(predicate.apply(supplier.get()), "supplied=" + supplier.get() + "; predicate=" + predicate + (errMsg != null ? "; " + errMsg : ""));
            if (periodMs > 0L) {
                Asserts.sleep(periodMs);
            }
            first = false;
        }
    }

    public static void succeedsEventually(Runnable r) {
        Asserts.succeedsEventually(ImmutableMap.of(), r);
    }

    public static void succeedsEventually(Map<String, ?> flags, Runnable r) {
        Asserts.succeedsEventually(flags, Asserts.toCallable(r));
    }

    public static void succeedsEventually(Callable<?> c) {
        Asserts.succeedsEventually(ImmutableMap.of(), c);
    }

    public static void succeedsEventually(Map<String, ?> flags, Callable<?> c) {
        boolean abortOnException = Asserts.get(flags, "abortOnException", false);
        boolean abortOnError = Asserts.get(flags, "abortOnError", false);
        boolean useGroovyTruth = Asserts.get(flags, "useGroovyTruth", false);
        boolean logException = Asserts.get(flags, "logException", true);
        Duration duration = Asserts.toDuration(flags.get("timeout"), Duration.THIRTY_SECONDS);
        Duration fixedPeriod = Asserts.toDuration(flags.get("period"), null);
        Duration minPeriod = fixedPeriod != null ? fixedPeriod : Asserts.toDuration(flags.get("minPeriod"), Duration.millis(1));
        Duration maxPeriod = fixedPeriod != null ? fixedPeriod : Asserts.toDuration(flags.get("maxPeriod"), Duration.millis(500));
        int maxAttempts = Asserts.get(flags, "maxAttempts", Integer.MAX_VALUE);
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        try {
            Throwable lastException = null;
            Object result = null;
            long lastAttemptTime = 0L;
            long expireTime = startTime + duration.toMilliseconds();
            long sleepTimeBetweenAttempts = minPeriod.toMilliseconds();
            while (attempt < maxAttempts && lastAttemptTime < expireTime) {
                block16: {
                    try {
                        ++attempt;
                        lastAttemptTime = System.currentTimeMillis();
                        result = c.call();
                        if (log.isTraceEnabled()) {
                            log.trace("Attempt {} after {} ms: {}", new Object[]{attempt, System.currentTimeMillis() - startTime, result});
                        }
                        if (useGroovyTruth) {
                            if (Asserts.groovyTruth(result)) {
                                return;
                            }
                        } else {
                            if (Boolean.FALSE.equals(result)) {
                                if (result instanceof BooleanWithMessage) {
                                    log.warn("Test returned an instance of BooleanWithMessage but useGroovyTruth is not set! The result of this probably isn't what you intended.");
                                }
                                return;
                            }
                            return;
                        }
                        lastException = null;
                    }
                    catch (Throwable e) {
                        lastException = e;
                        if (log.isTraceEnabled()) {
                            log.trace("Attempt {} after {} ms: {}", new Object[]{attempt, System.currentTimeMillis() - startTime, e.getMessage()});
                        }
                        if (abortOnException) {
                            throw e;
                        }
                        if (!abortOnError || !(e instanceof Error)) break block16;
                        throw e;
                    }
                }
                long sleepTime = Math.min(sleepTimeBetweenAttempts, expireTime - System.currentTimeMillis());
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                sleepTimeBetweenAttempts = Math.min(sleepTimeBetweenAttempts * 2L, maxPeriod.toMilliseconds());
            }
            log.debug("TestUtils.executeUntilSucceedsWithFinallyBlockInternal exceeded max attempts or timeout - {} attempts lasting {} ms", (Object)attempt, (Object)(System.currentTimeMillis() - startTime));
            if (lastException != null) {
                throw lastException;
            }
            Asserts.fail("invalid result: " + result);
        }
        catch (Throwable t) {
            if (logException) {
                log.info("failed succeeds-eventually, " + attempt + " attempts, " + (System.currentTimeMillis() - startTime) + "ms elapsed " + "(rethrowing): " + t);
            }
            throw Asserts.propagate(t);
        }
    }

    public static <T> void succeedsContinually(Runnable r) {
        Asserts.succeedsContinually(ImmutableMap.of(), r);
    }

    public static <T> void succeedsContinually(Map<String, ?> flags, Runnable r) {
        Asserts.succeedsContinually(flags, Asserts.toCallable(r));
    }

    public static void succeedsContinually(Callable<?> c) {
        Asserts.succeedsContinually(ImmutableMap.of(), c);
    }

    public static void succeedsContinually(Map<String, ?> flags, Callable<?> job) {
        Duration duration = Asserts.toDuration(flags.get("timeout"), Duration.ONE_SECOND);
        Duration period = Asserts.toDuration(flags.get("period"), Duration.millis(10));
        long periodMs = period.toMilliseconds();
        long startTime = System.currentTimeMillis();
        long expireTime = startTime + duration.toMilliseconds();
        boolean first = true;
        while (first || System.currentTimeMillis() <= expireTime) {
            try {
                job.call();
            }
            catch (Exception e) {
                throw Asserts.propagate(e);
            }
            if (periodMs > 0L) {
                Asserts.sleep(periodMs);
            }
            first = false;
        }
    }

    private static Duration toDuration(Object duration) {
        return Duration.of(duration);
    }

    private static Duration toDuration(Object duration, Duration defaultVal) {
        if (duration == null) {
            return defaultVal;
        }
        return Duration.of(duration);
    }

    public static void assertFails(Runnable r) {
        Asserts.assertFailsWith(Asserts.toCallable(r), (Predicate<? super Throwable>)Predicates.alwaysTrue());
    }

    public static void assertFails(Callable<?> c) {
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)Predicates.alwaysTrue());
    }

    public static void assertFailsWith(Callable<?> c, final Closure<Boolean> exceptionChecker) {
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return (Boolean)exceptionChecker.call((Object)input);
            }
        });
    }

    public static void assertFailsWith(Runnable c, Class<? extends Throwable> validException, Class<? extends Throwable> ... otherValidExceptions) {
        ImmutableList validExceptions = ImmutableList.builder().add(validException).addAll((Iterable)ImmutableList.copyOf((Object[])otherValidExceptions)).build();
        Asserts.assertFailsWith(c, (Predicate<? super Throwable>)new Predicate<Throwable>((List)validExceptions){
            private final /* synthetic */ List val$validExceptions;
            {
                this.val$validExceptions = list;
            }

            public boolean apply(Throwable e) {
                for (Class validException : this.val$validExceptions) {
                    if (!validException.isInstance(e)) continue;
                    return true;
                }
                Asserts.fail("Test threw exception of unexpected type " + e.getClass() + "; expecting " + this.val$validExceptions);
                return false;
            }
        });
    }

    public static void assertFailsWith(Runnable r, Predicate<? super Throwable> exceptionChecker) {
        Asserts.assertFailsWith(Asserts.toCallable(r), exceptionChecker);
    }

    public static void assertFailsWith(Callable<?> c, Predicate<? super Throwable> exceptionChecker) {
        boolean failed = false;
        try {
            c.call();
        }
        catch (Throwable e) {
            failed = true;
            if (!exceptionChecker.apply((Object)e)) {
                log.debug("Test threw invalid exception (failing)", e);
                Asserts.fail("Test threw invalid exception: " + e);
            }
            log.debug("Test for exception successful (" + e + ")");
        }
        if (!failed) {
            Asserts.fail("Test code should have thrown exception but did not");
        }
    }

    private static boolean groovyTruth(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return !((String)o).isEmpty();
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof Iterator) {
            return ((Iterator)o).hasNext();
        }
        if (o instanceof Enumeration) {
            return ((Enumeration)o).hasMoreElements();
        }
        return true;
    }

    private static <T> T get(Map<String, ?> map, String key, T defaultVal) {
        Object val = map.get(key);
        return (T)(val == null ? defaultVal : val);
    }

    private static Callable<?> toCallable(Runnable r) {
        return r instanceof Callable ? (Callable<Object>)((Object)r) : Executors.callable(r);
    }

    private static void sleep(long periodMs) {
        if (periodMs > 0L) {
            try {
                Thread.sleep(periodMs);
            }
            catch (InterruptedException e) {
                throw Asserts.propagate(e);
            }
        }
    }

    private static RuntimeException propagate(Throwable t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static class BooleanWithMessage {
        boolean value;
        String message;

        public BooleanWithMessage(boolean value, String message) {
            this.value = value;
            this.message = message;
        }

        public boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.message;
        }
    }
}

