/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.time.TimeDuration;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGroovyEquivalents {
    private static final Logger log = LoggerFactory.getLogger(JavaGroovyEquivalents.class);

    public static String join(Collection<?> collection, String separator) {
        StringBuffer result = new StringBuffer();
        Iterator<?> ci = collection.iterator();
        if (ci.hasNext()) {
            result.append(JavaGroovyEquivalents.asNonnullString(ci.next()));
        }
        while (ci.hasNext()) {
            result.append(separator);
            result.append(JavaGroovyEquivalents.asNonnullString(ci.next()));
        }
        return result.toString();
    }

    public static <T> Collection<T> elvis(Collection<T> preferred, Collection<?> fallback) {
        return JavaGroovyEquivalents.groovyTruth(preferred) ? preferred : fallback;
    }

    public static String elvis(String preferred, String fallback) {
        return JavaGroovyEquivalents.groovyTruth(preferred) ? preferred : fallback;
    }

    public static String elvisString(Object preferred, Object fallback) {
        return JavaGroovyEquivalents.elvis(JavaGroovyEquivalents.asString(preferred), JavaGroovyEquivalents.asString(fallback));
    }

    public static <T> T elvis(T preferred, T fallback) {
        return JavaGroovyEquivalents.groovyTruth(preferred) ? preferred : fallback;
    }

    public static <T> T elvis(Iterable<?> preferences) {
        return JavaGroovyEquivalents.elvis(Iterables.toArray(preferences, Object.class));
    }

    public static <T> T elvis(Object ... preferences) {
        if (preferences.length == 0) {
            throw new IllegalArgumentException("preferences must not be empty for elvis");
        }
        Object[] objectArray = preferences;
        int n = preferences.length;
        int n2 = 0;
        while (n2 < n) {
            Object contender = objectArray[n2];
            if (JavaGroovyEquivalents.groovyTruth(contender)) {
                return (T)JavaGroovyEquivalents.fix(contender);
            }
            ++n2;
        }
        return (T)JavaGroovyEquivalents.fix(preferences[preferences.length - 1]);
    }

    public static Object fix(Object o) {
        if (o instanceof GString) {
            return o.toString();
        }
        return o;
    }

    public static String asString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String asNonnullString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public static boolean groovyTruth(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public static boolean groovyTruth(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean groovyTruth(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return !((String)o).isEmpty();
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof Iterator) {
            return ((Iterator)o).hasNext();
        }
        if (o instanceof Enumeration) {
            return ((Enumeration)o).hasMoreElements();
        }
        return true;
    }

    public static <T> Predicate<T> groovyTruthPredicate() {
        return new Predicate<T>(){

            public boolean apply(T val) {
                return JavaGroovyEquivalents.groovyTruth(val);
            }
        };
    }

    public static Function<Object, Boolean> groovyTruthFunction() {
        return new Function<Object, Boolean>(){

            public Boolean apply(Object input) {
                return JavaGroovyEquivalents.groovyTruth(input);
            }
        };
    }

    public static <K, V> Map<K, V> mapOf(K key1, V val1) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(key1, val1);
        return result;
    }

    @Deprecated
    public static TimeDuration toTimeDuration(Object duration) {
        if (duration == null) {
            return null;
        }
        if (duration instanceof TimeDuration) {
            return (TimeDuration)duration;
        }
        if (duration instanceof Number) {
            long d = ((Number)duration).longValue();
            if (d <= Integer.MAX_VALUE && d >= Integer.MIN_VALUE) {
                return new TimeDuration(0, 0, 0, (int)d);
            }
            log.warn("Number " + d + " too large to convert to TimeDuration; using Integer.MAX_VALUE instead");
            return new TimeDuration(0, 0, 0, Integer.MAX_VALUE);
        }
        throw new IllegalArgumentException("Cannot convert " + duration + " of type " + duration.getClass().getName() + " to a TimeDuration");
    }

    public static <T> Predicate<T> toPredicate(final Closure<Boolean> c) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return (Boolean)c.call(input);
            }
        };
    }
}

