/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.stream.StreamGobbler;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import groovy.io.GroovyPrintStream;
import groovy.time.TimeDuration;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ShellUtils {
    public static long TIMEOUT = 60000L;

    public static String[] exec(String cmd, Logger log, Object context) {
        return ShellUtils.exec(cmd, null, log, context);
    }

    public static String[] exec(String cmd, String input, Logger log, Object context) {
        return ShellUtils.exec(new String[]{"bash", "-l", "-c", cmd}, null, null, input, log, context);
    }

    public static String[] exec(Map flags, String cmd, Logger log, Object context) {
        return ShellUtils.exec(flags, new String[]{"bash", "-l", "-c", cmd}, null, null, null, log, context);
    }

    public static String[] exec(Map flags, String cmd, String input, Logger log, Object context) {
        return ShellUtils.exec(flags, new String[]{"bash", "-l", "-c", cmd}, null, null, input, log, context);
    }

    public static String[] exec(String[] cmd, String[] envp, File dir, String input, Logger log, Object context) {
        return ShellUtils.exec(Maps.newLinkedHashMap(), cmd, envp, dir, input, log, context);
    }

    private static long getTimeoutMs(Map flags) {
        long timeout = TIMEOUT;
        Object tf = flags.get("timeout");
        if (tf instanceof Number) {
            timeout = ((Number)tf).longValue();
        } else if (tf instanceof TimeDuration) {
            timeout = ((TimeDuration)tf).toMilliseconds();
        }
        return timeout;
    }

    public static String[] exec(Map flags, final String[] cmd, String[] envp, File dir, String input, final Logger log, final Object context) {
        if (log.isDebugEnabled()) {
            log.debug("Running local command: {}% {}", context, (Object)Strings.join(cmd, " "));
        }
        Closer closer = Closer.create();
        try {
            final Process proc = Runtime.getRuntime().exec(cmd, envp, dir);
            ByteArrayOutputStream stdoutB = new ByteArrayOutputStream();
            ByteArrayOutputStream stderrB = new ByteArrayOutputStream();
            GroovyPrintStream stdoutP = new GroovyPrintStream((OutputStream)stdoutB);
            GroovyPrintStream stderrP = new GroovyPrintStream((OutputStream)stderrB);
            StreamGobbler stdoutG = new StreamGobbler(proc.getInputStream(), (PrintStream)stdoutP, log).setLogPrefix("[" + context + ":stdout] ");
            stdoutG.start();
            closer.register((Closeable)stdoutG);
            StreamGobbler stderrG = new StreamGobbler(proc.getErrorStream(), (PrintStream)stderrP, log).setLogPrefix("[" + context + ":stderr] ");
            stderrG.start();
            closer.register((Closeable)stderrG);
            if (input != null && input.length() > 0) {
                proc.getOutputStream().write(input.getBytes());
                proc.getOutputStream().flush();
            }
            final long timeout = ShellUtils.getTimeoutMs(flags);
            final AtomicBoolean ended = new AtomicBoolean(false);
            final AtomicBoolean killed = new AtomicBoolean(false);
            Thread timeoutThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (timeout <= 0L) {
                        return;
                    }
                    try {
                        Thread.sleep(timeout);
                        if (!ended.get()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Timeout exceeded for " + context + "% " + Strings.join(cmd, " "));
                            }
                            proc.destroy();
                            killed.set(true);
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            if (timeout > 0L) {
                timeoutThread.start();
            }
            int exitCode = proc.waitFor();
            ended.set(true);
            if (timeout > 0L) {
                timeoutThread.interrupt();
            }
            stdoutG.blockUntilFinished();
            stderrG.blockUntilFinished();
            if (exitCode != 0 || killed.get()) {
                String message;
                String string = message = killed.get() ? "terminated after timeout" : "exit code " + exitCode;
                if (log.isDebugEnabled()) {
                    log.debug("Completed local command (problem, throwing): " + context + "% " + Strings.join(cmd, " ") + " - " + message);
                }
                String e = "Command failed (" + message + "): " + Strings.join(cmd, " ");
                log.warn(String.valueOf(e) + "\n" + stdoutB + (stderrB.size() > 0 ? "\n--\n" + stderrB : ""));
                throw new IllegalStateException(String.valueOf(e) + " (details logged)");
            }
            if (log.isDebugEnabled()) {
                log.debug("Completed local command: " + context + "% " + Strings.join(cmd, " ") + " - exit code 0");
            }
            String[] stringArray = stdoutB.toString().split("\n");
            return stringArray;
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
        finally {
            Streams.closeQuietly((Closeable)closer);
        }
    }
}

