/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class MutableList<V>
extends ArrayList<V> {
    private static final long serialVersionUID = -5533940507175152491L;

    public static <V> MutableList<V> of() {
        return new MutableList<V>();
    }

    public static <V> MutableList<V> of(V v1) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        return result;
    }

    public static <V> MutableList<V> of(V v1, V v2) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        result.add(v2);
        return result;
    }

    public static <V> MutableList<V> of(V v1, V v2, V v3) {
        MutableList<V> result = new MutableList<V>();
        result.add(v1);
        result.add(v2);
        result.add(v3);
        return result;
    }

    public static <V> MutableList<V> copyOf(Iterable<? extends V> orig) {
        return new MutableList<V>(orig);
    }

    public MutableList() {
    }

    public MutableList(Iterable<? extends V> source) {
        super(source instanceof Collection ? (Collection)source : ImmutableList.copyOf(source));
    }

    public ImmutableList<V> toImmutable() {
        return ImmutableList.copyOf((Collection)this);
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public static class Builder<V> {
        final MutableList<V> result = new MutableList();

        public Builder<V> add(V value) {
            this.result.add(value);
            return this;
        }

        public Builder<V> remove(V val) {
            this.result.remove(val);
            return this;
        }

        public Builder<V> addAll(V ... values) {
            V[] VArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                V v = VArray[n2];
                this.result.add(v);
                ++n2;
            }
            return this;
        }

        public Builder<V> addAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.addAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.add(v);
                }
            }
            return this;
        }

        public Builder<V> removeAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.removeAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.remove(v);
                }
            }
            return this;
        }

        public Builder<V> removeAll(V ... values) {
            V[] VArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                V v = VArray[n2];
                this.result.remove(v);
                ++n2;
            }
            return this;
        }

        public MutableList<V> build() {
            return new MutableList<V>(this.result);
        }

        public ImmutableList<V> buildImmutable() {
            return ImmutableList.copyOf(this.result);
        }
    }
}

