/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MutableMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -2463168443382874384L;

    public static <K, V> MutableMap<K, V> of() {
        return new MutableMap<K, V>();
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        result.put(k6, v6);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        result.put(k6, v6);
        result.put(k7, v7);
        return result;
    }

    public static <K, V> MutableMap<K, V> copyOf(Map<? extends K, ? extends V> orig) {
        MutableMap<? extends K, ? extends V> result = new MutableMap<K, V>();
        result.putAll(orig);
        return result;
    }

    public MutableMap() {
    }

    public MutableMap(Map source) {
        super(source);
    }

    public MutableMap<K, V> add(K key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableMap<K, V> add(Map<K, V> m) {
        this.putAll(m);
        return this;
    }

    public MutableMap<K, V> addIfNotNull(K key, V value) {
        if (value != null) {
            this.add(key, value);
        }
        return this;
    }

    public ImmutableMap<K, V> toImmutable() {
        return ImmutableMap.copyOf((Map)this);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        final MutableMap<K, V> result = new MutableMap();

        public Builder<K, V> put(K key, V value) {
            this.result.put(key, value);
            return this;
        }

        public Builder<K, V> putIfNotNull(K key, V value) {
            if (value != null) {
                this.result.put(key, value);
            }
            return this;
        }

        public Builder<K, V> putIfAbsent(K key, V value) {
            if (!this.result.containsKey(key)) {
                this.result.put(key, value);
            }
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            this.result.put(entry.getKey(), entry.getValue());
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            this.result.putAll(map);
            return this;
        }

        public Builder<K, V> removeAll(K ... keys) {
            K[] KArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                K key = KArray[n2];
                this.result.remove(key);
                ++n2;
            }
            return this;
        }

        public Builder<K, V> removeAll(Iterable<? extends K> keys) {
            for (K key : keys) {
                this.result.remove(key);
            }
            return this;
        }

        public MutableMap<K, V> build() {
            return new MutableMap(this.result);
        }
    }
}

