/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MutableSet<V>
extends LinkedHashSet<V> {
    private static final long serialVersionUID = 2330133488446834595L;

    public static <V> MutableSet<V> of() {
        return new MutableSet<V>();
    }

    public static <V> MutableSet<V> of(V v1) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        return result;
    }

    public static <V> MutableSet<V> of(V v1, V v2) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        result.add(v2);
        return result;
    }

    public static <V> MutableSet<V> of(V v1, V v2, V v3) {
        MutableSet<V> result = new MutableSet<V>();
        result.add(v1);
        result.add(v2);
        result.add(v3);
        return result;
    }

    public static <V> MutableSet<V> copyOf(Iterable<? extends V> orig) {
        return new MutableSet<V>(orig);
    }

    public MutableSet() {
    }

    public MutableSet(Iterable<? extends V> source) {
        super(source instanceof Collection ? (Collection)source : Sets.newLinkedHashSet(source));
    }

    public Set<V> toImmutable() {
        return Collections.unmodifiableSet(Sets.newLinkedHashSet((Iterable)this));
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public static class Builder<V> {
        final MutableSet<V> result = new MutableSet();

        public Builder<V> add(V value) {
            this.result.add(value);
            return this;
        }

        public Builder<V> remove(V val) {
            this.result.remove(val);
            return this;
        }

        public Builder<V> addAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.addAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.add(v);
                }
            }
            return this;
        }

        public Builder<V> addAll(V ... values) {
            V[] VArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                V v = VArray[n2];
                this.result.add(v);
                ++n2;
            }
            return this;
        }

        public Builder<V> removeAll(Iterable<? extends V> iterable) {
            if (iterable instanceof Collection) {
                this.result.removeAll((Collection)iterable);
            } else {
                for (V v : iterable) {
                    this.result.remove(v);
                }
            }
            return this;
        }

        public Builder<V> removeAll(V ... values) {
            V[] VArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                V v = VArray[n2];
                this.result.remove(v);
                ++n2;
            }
            return this;
        }

        public MutableSet<V> build() {
            return new MutableSet<V>(this.result);
        }
    }
}

