/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import brooklyn.util.collections.TimestampedValue;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TimeWindowedList<T> {
    private final LinkedList<TimestampedValue<T>> values = new LinkedList();
    private volatile long timePeriod;
    private final int minVals;
    private final int minExpiredVals;

    public TimeWindowedList(long timePeriod) {
        this.timePeriod = timePeriod;
        this.minVals = 0;
        this.minExpiredVals = 0;
    }

    public TimeWindowedList(Map<String, ?> flags) {
        if (!flags.containsKey("timePeriod")) {
            throw new IllegalArgumentException("Must define timePeriod");
        }
        this.timePeriod = ((Number)flags.get("timePeriod")).longValue();
        this.minVals = flags.containsKey("minVals") ? ((Number)flags.get("minVals")).intValue() : 0;
        this.minExpiredVals = flags.containsKey("minExpiredVals") ? ((Number)flags.get("minExpiredVals")).intValue() : 0;
    }

    public void setTimePeriod(long newTimePeriod) {
        this.timePeriod = newTimePeriod;
    }

    public synchronized T getLatestValue() {
        return this.values.isEmpty() ? null : (T)this.values.get(this.values.size() - 1).getValue();
    }

    public List<TimestampedValue<T>> getValues() {
        return this.getValues(System.currentTimeMillis());
    }

    public synchronized List<TimestampedValue<T>> getValues(long now) {
        this.pruneValues(now);
        return ImmutableList.copyOf(this.values);
    }

    public synchronized List<TimestampedValue<T>> getValuesInWindow(long now, long subTimePeriod) {
        LinkedList<TimestampedValue<T>> result = new LinkedList<TimestampedValue<T>>();
        TimestampedValue mostRecentExpired = null;
        for (TimestampedValue timestampedValue : this.values) {
            if (timestampedValue.getTimestamp() < now - subTimePeriod) {
                mostRecentExpired = timestampedValue;
                continue;
            }
            result.add(timestampedValue);
        }
        if (this.minExpiredVals > 0 && mostRecentExpired != null) {
            result.add(0, mostRecentExpired);
        }
        if (result.size() < this.minVals) {
            int n = Math.max(0, this.values.size() - this.minVals);
            return ImmutableList.copyOf(this.values.subList(n, this.values.size()));
        }
        return result;
    }

    public void add(T val) {
        this.add(val, System.currentTimeMillis());
    }

    public synchronized void add(T val, long timestamp) {
        this.values.add(this.values.size(), new TimestampedValue<T>(val, timestamp));
        this.pruneValues(timestamp);
    }

    public synchronized void pruneValues(long now) {
        int expiredValsCount = 0;
        for (TimestampedValue timestampedValue : this.values) {
            if (this.timePeriod != 0L && timestampedValue.getTimestamp() >= now - this.timePeriod) break;
            ++expiredValsCount;
        }
        int n = Math.min(expiredValsCount - this.minExpiredVals, this.values.size() - this.minVals);
        int i = 0;
        while (i < n) {
            this.values.removeFirst();
            ++i;
        }
    }

    public String toString() {
        return "timePeriod=" + this.timePeriod + ", vals=" + this.values;
    }
}

