/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.exceptions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;

public class CompoundRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6110995537064639587L;
    private final List<Throwable> causes;

    public CompoundRuntimeException(String message) {
        super(message);
        this.causes = Collections.emptyList();
    }

    public CompoundRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.causes = cause == null ? Collections.emptyList() : Collections.singletonList(cause);
    }

    public CompoundRuntimeException(Throwable cause) {
        super(cause);
        this.causes = cause == null ? Collections.emptyList() : Collections.singletonList(cause);
    }

    public CompoundRuntimeException(String message, Iterable<? extends Throwable> causes) {
        super(message, Iterables.isEmpty(causes) ? null : (Throwable)Iterables.get(causes, (int)0));
        this.causes = ImmutableList.copyOf(causes);
    }

    public List<Throwable> getAllCauses() {
        return this.causes;
    }
}

