/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AggregateClassLoader
extends ClassLoader {
    private final List<ClassLoader> classLoaders = new CopyOnWriteArrayList<ClassLoader>();

    private AggregateClassLoader() {
    }

    public static AggregateClassLoader newInstanceWithDefaultLoaders() {
        AggregateClassLoader cl = new AggregateClassLoader();
        cl.addFirst(AggregateClassLoader.class.getClassLoader());
        cl.addFirst(Object.class.getClassLoader());
        return cl;
    }

    public static AggregateClassLoader newInstanceWithNoLoaders() {
        return new AggregateClassLoader();
    }

    public void addFirst(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.add(0, classLoader);
        }
    }

    public void addLast(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.add(classLoader);
        }
    }

    public void add(int index, ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.add(index, classLoader);
        }
    }

    public List<ClassLoader> getList() {
        return this.classLoaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader.loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    public String toString() {
        return "AggregateClassLoader" + this.classLoaders;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        for (ClassLoader classLoader : this.classLoaders) {
            result = classLoader.getResource(name);
            if (result == null) continue;
            return result;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader.getResource(name);
        }
        return null;
    }
}

