/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import brooklyn.util.collections.MutableList;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflections {
    protected static final Logger LOG = LoggerFactory.getLogger(Reflections.class);
    private final ClassLoader classLoader;

    public Reflections(ClassLoader classLoader) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
    }

    public Object loadInstance(String classname, Class<?>[] argTypes, Object[] argValues) throws ReflectionNotFoundException, ReflectionAccessException {
        Class<?> clazz = this.loadClass(classname);
        Constructor<?> constructor = this.loadConstructor(clazz, argTypes);
        return this.loadInstance(constructor, argValues);
    }

    public Object loadInstance(String classname) throws ReflectionNotFoundException, ReflectionAccessException {
        Class<?> clazz = this.loadClass(classname);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ReflectionAccessException("Failed to create instance of class '" + classname + "' using class loader " + this.classLoader, e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to create instance of class '" + classname + "' using class loader " + this.classLoader, e);
        }
    }

    public Class<?> loadClass(String classname) throws ReflectionNotFoundException {
        try {
            return this.classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader, e);
        }
        catch (NoClassDefFoundError e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader, e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new ReflectionNotFoundException("Failed to load class '" + classname + "' using class loader " + this.classLoader, e);
        }
    }

    public static Class<?> loadInnerClassPossiblyInheritted(Class<?> clazz, String nestedPart) throws ReflectionNotFoundException {
        HashSet<String> visited = new HashSet<String>();
        Class<?> result = Reflections.loadInnerClassPossiblyInheritted(visited, clazz, nestedPart);
        if (result != null) {
            return result;
        }
        throw new ReflectionNotFoundException("Inner class " + nestedPart + " could not be found in " + clazz + " or any of its super-types");
    }

    private static Class<?> loadInnerClassPossiblyInheritted(Set<String> visited, Class<?> clazz, String nestedPart) throws ReflectionNotFoundException {
        if (clazz == null) {
            return null;
        }
        if (nestedPart == null || nestedPart.length() == 0) {
            return clazz;
        }
        int i1 = nestedPart.indexOf(36);
        int i2 = nestedPart.indexOf(46);
        int idx = i2 > -1 && (i2 < i1 || i1 == -1) ? i2 : i1;
        String thisClassToFind = nestedPart;
        String nextClassesToFind = "";
        if (idx >= 0) {
            thisClassToFind = nestedPart.substring(0, idx);
            nextClassesToFind = nestedPart.substring(idx + 1);
        }
        if (!visited.add(String.valueOf(clazz.getCanonicalName()) + "!" + nestedPart)) {
            return null;
        }
        Class<?>[] members = clazz.getClasses();
        int i = 0;
        while (i < members.length) {
            Class<?> clazzI;
            if (members[i].getSimpleName().equals(thisClassToFind) && (clazzI = Reflections.loadInnerClassPossiblyInheritted(visited, members[i], nextClassesToFind)) != null) {
                return clazzI;
            }
            ++i;
        }
        Class<?> result = Reflections.loadInnerClassPossiblyInheritted(visited, clazz.getSuperclass(), nestedPart);
        if (result != null) {
            return result;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            result = Reflections.loadInnerClassPossiblyInheritted(visited, iface, nestedPart);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public Class<?> loadInnerClassNotInheritted(String outerClassname, String innerClassname) throws ReflectionNotFoundException {
        return this.loadClass(String.valueOf(outerClassname) + "$" + innerClassname);
    }

    public Class<?> loadInnerClassNotInheritted(Class<?> outerClazz, String innerClassname) throws ReflectionNotFoundException {
        return this.loadClass(String.valueOf(outerClazz.getName()) + "$" + innerClassname);
    }

    public Constructor<?> loadConstructor(Class<?> clazz, Class<?>[] argTypes) throws ReflectionAccessException {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to load constructor of class '" + clazz + " with argument types " + Arrays.asList(argTypes), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionAccessException("Failed to load constructor of class '" + clazz + " with argument types " + Arrays.asList(argTypes), e);
        }
    }

    public static <T> Constructor<T> findCallabaleConstructor(Class<T> clazz, Object[] args) {
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = args[i] != null ? args[i].getClass() : null;
            ++i;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (Reflections.isCallableConstructor(constructor, argTypes)) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isCallableConstructor(Constructor<?> constructor, Class<?>[] argTypes) {
        Class<?>[] expectedTypes = constructor.getParameterTypes();
        if (expectedTypes.length != argTypes.length) {
            return false;
        }
        int i = 0;
        while (i < argTypes.length) {
            if (argTypes[i] != null && !expectedTypes[i].isAssignableFrom(argTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Constructor<?> loadSingleConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        throw new IllegalArgumentException("Class " + clazz + " has more than one constructor");
    }

    public <T> T loadInstance(Constructor<T> constructor, Object[] argValues) throws IllegalArgumentException, ReflectionAccessException {
        try {
            try {
                return constructor.newInstance(argValues);
            }
            catch (IllegalArgumentException e) {
                try {
                    try {
                        LOG.warn("Failure passing provided arguments (" + Reflections.getIllegalArgumentsErrorMessage(constructor, argValues) + "; " + e + "); attempting to reconstitute");
                        argValues = (Object[])this.updateFromNewClassLoader(argValues);
                        return constructor.newInstance(argValues);
                    }
                    catch (Throwable e2) {
                        LOG.warn("Reconstitution attempt failed (will rethrow original excaption): " + e2, e2);
                        throw e;
                    }
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(constructor, argValues), e2);
                }
            }
        }
        catch (InstantiationException e) {
            throw new ReflectionAccessException("Failed to create instance of '" + constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to create instance of '" + constructor.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to create instance of '" + constructor.getDeclaringClass(), e);
        }
    }

    public Method loadMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) throws ReflectionNotFoundException, ReflectionAccessException {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoClassDefFoundError e) {
            throw new ReflectionNotFoundException("Failed to invoke method '" + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes) + ", using class loader " + clazz.getClassLoader(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionNotFoundException("Failed to invoke method '" + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes), e);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + methodName + " on class " + clazz + " with argument types " + Arrays.asList(argTypes), e);
        }
    }

    public Method loadMethod(Class<?> clazz, String methodName) throws ReflectionNotFoundException, ReflectionAccessException {
        try {
            Method[] allmethods = clazz.getMethods();
            int i = 0;
            while (i < allmethods.length) {
                if (allmethods[i].getName().equals(methodName)) {
                    return allmethods[i];
                }
                ++i;
            }
            throw new ReflectionNotFoundException("Cannot find method " + methodName + " on class " + clazz);
        }
        catch (SecurityException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + methodName + " on class " + clazz, e);
        }
    }

    public Object invokeMethod(Method method, Object obj, Object ... argValues) throws ReflectionAccessException {
        try {
            return method.invoke(obj, argValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(method, argValues), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues), e);
        }
    }

    public Object invokeStaticMethod(Method method, Object ... argValues) throws IllegalArgumentException, ReflectionAccessException {
        try {
            return method.invoke(null, argValues);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Reflections.getIllegalArgumentsErrorMessage(method, argValues), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionAccessException("Failed to invoke method '" + method.toGenericString() + " on class " + method.getDeclaringClass() + " with argument values " + Arrays.asList(argValues), e);
        }
    }

    public Object loadStaticField(Class<?> clazz, String fieldname) throws ReflectionAccessException {
        return this.loadStaticFields(clazz, new String[]{fieldname}, null)[0];
    }

    public Object[] loadStaticFields(Class<?> clazz, String[] fieldnamesArray, Object[] defaults) throws ReflectionAccessException {
        Object[] result = new Object[fieldnamesArray.length];
        if (defaults != null) {
            int i = 0;
            while (i < defaults.length) {
                result[i] = defaults[i];
                ++i;
            }
        }
        List<String> fieldnames = Arrays.asList(fieldnamesArray);
        Field[] classFields = clazz.getDeclaredFields();
        int i = 0;
        while (i < classFields.length) {
            Field field = classFields[i];
            int index = fieldnames.indexOf(field.getName());
            if (index >= 0) {
                try {
                    result[index] = field.get(null);
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionAccessException("Failed to load field '" + field.getName() + " from class " + clazz, e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionAccessException("Failed to load field '" + field.getName() + " from class " + clazz, e);
                }
            }
            ++i;
        }
        return result;
    }

    private static String getIllegalArgumentsErrorMessage(Method method, Object[] argValues) {
        return String.valueOf(method.toGenericString()) + " not applicable for the parameters of type " + Reflections.argumentTypesToString(argValues);
    }

    private static String getIllegalArgumentsErrorMessage(Constructor<?> constructor, Object[] argValues) {
        return String.valueOf(constructor.toGenericString()) + " not applicable for the parameters of type " + Reflections.argumentTypesToString(argValues);
    }

    private static String argumentTypesToString(Object[] argValues) {
        StringBuffer msg = new StringBuffer("(");
        int i = 0;
        while (i < argValues.length) {
            if (i != 0) {
                msg.append(", ");
            }
            msg.append(argValues[i] != null ? argValues[i].getClass().getName() : "null");
            ++i;
        }
        msg.append(")");
        return msg.toString();
    }

    public static <T> void copyFields(T source, T target) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = source.getClass();
        while (clazz != null) {
            Field[] fields;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                Object vs = f.get(source);
                Object vt = f.get(target);
                if (vs == null && vt != null || vs != null && !vs.equals(vt)) {
                    f.set(target, vs);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    public Class<?> loadClassFromCanonicalName(String canonicalName) throws ClassNotFoundException, ReflectionNotFoundException {
        ClassNotFoundException err = null;
        String name = canonicalName;
        while (true) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                int lastIndexOf;
                if (err == null) {
                    err = e;
                }
                if ((lastIndexOf = name.lastIndexOf(".")) < 0) continue;
                name = String.valueOf(name.substring(0, lastIndexOf)) + "$" + name.substring(lastIndexOf + 1);
                if (name.contains(".")) continue;
                throw err;
            }
            break;
        }
    }

    @Nullable
    public URL getResource(String r) {
        URL u = null;
        u = this.classLoader.getResource(r);
        if (u != null) {
            return u;
        }
        r = r.startsWith("/") ? r.substring(1) : "/" + r;
        return this.classLoader.getResource(r);
    }

    public final Object updateFromNewClassLoader(Object data) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new ObjectOutputStream(bytes).writeObject(data);
        Object reconstituted = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())).readObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconstituted data: " + reconstituted + ", class loader: " + this.classLoader);
        }
        return reconstituted;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static StackTraceElement getCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[3];
    }

    public static <T> Class<? super T> findSuperType(T impl, String typeName) {
        LinkedHashSet toinspect = new LinkedHashSet();
        HashSet<Class> inspected = new HashSet<Class>();
        toinspect.add(impl.getClass());
        while (toinspect.size() > 0) {
            Class clazz = (Class)toinspect.iterator().next();
            if (clazz.getName().equals(typeName)) {
                return clazz;
            }
            inspected.add(clazz);
            List<Class<?>> toAdd = Arrays.asList(clazz.getInterfaces());
            toinspect.addAll(toAdd);
            if (clazz.getSuperclass() != null) {
                toinspect.add(clazz.getSuperclass());
            }
            toinspect.removeAll(inspected);
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (clazz == null || name == null) {
            throw new NullPointerException("Must not be null: clazz=" + clazz + "; name=" + name);
        }
        Class<?> clazzToInspect = clazz;
        NoSuchMethodException toThrowIfFails = null;
        while (clazzToInspect != null) {
            try {
                return clazzToInspect.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (toThrowIfFails == null) {
                    toThrowIfFails = e;
                }
                clazzToInspect = clazzToInspect.getSuperclass();
            }
        }
        throw toThrowIfFails;
    }

    public static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        if (clazz == null || name == null) {
            throw new NullPointerException("Must not be null: clazz=" + clazz + "; name=" + name);
        }
        Class<?> clazzToInspect = clazz;
        NoSuchFieldException toThrowIfFails = null;
        while (clazzToInspect != null) {
            try {
                return clazzToInspect.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (toThrowIfFails == null) {
                    toThrowIfFails = e;
                }
                clazzToInspect = clazzToInspect.getSuperclass();
            }
        }
        throw toThrowIfFails;
    }

    public static List<Field> findPublicFieldsOrderedBySuper(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        MutableList.Builder result = MutableList.builder();
        Stack tovisit = new Stack();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        tovisit.push(clazz);
        while (!tovisit.isEmpty()) {
            Class nextclazz = (Class)tovisit.pop();
            if (!visited.add(nextclazz)) continue;
            if (nextclazz.getSuperclass() != null) {
                tovisit.add(nextclazz.getSuperclass());
            }
            tovisit.addAll(Arrays.asList(nextclazz.getInterfaces()));
            result.addAll(Iterables.filter(Arrays.asList(nextclazz.getDeclaredFields()), (Predicate)new Predicate<Field>(){

                public boolean apply(Field input) {
                    return Modifier.isPublic(input.getModifiers());
                }
            }));
        }
        MutableList<Field> resultList = result.build();
        Collections.sort(resultList, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                Field fsubbest = Reflections.inferSubbestField(f1, f2);
                return fsubbest == null ? 0 : (fsubbest == f1 ? 1 : -1);
            }
        });
        return resultList;
    }

    public static List<Method> findPublicMethodsOrderedBySuper(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        MutableList.Builder result = MutableList.builder();
        Stack tovisit = new Stack();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        tovisit.push(clazz);
        while (!tovisit.isEmpty()) {
            Class nextclazz = (Class)tovisit.pop();
            if (!visited.add(nextclazz)) continue;
            if (nextclazz.getSuperclass() != null) {
                tovisit.add(nextclazz.getSuperclass());
            }
            tovisit.addAll(Arrays.asList(nextclazz.getInterfaces()));
            result.addAll(Iterables.filter(Arrays.asList(nextclazz.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

                public boolean apply(Method input) {
                    return Modifier.isPublic(input.getModifiers());
                }
            }));
        }
        MutableList<Method> resultList = result.build();
        Collections.sort(resultList, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                Method msubbest = Reflections.inferSubbestMethod(m1, m2);
                return msubbest == null ? 0 : (msubbest == m1 ? 1 : -1);
            }
        });
        return resultList;
    }

    public static Field inferSubbestField(Field f1, Field f2) {
        Class<?> c1 = f1.getDeclaringClass();
        Class<?> c2 = f2.getDeclaringClass();
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : f2) : (isSuper2 ? f1 : null);
    }

    public static Method inferSubbestMethod(Method m1, Method m2) {
        Class<?> c1 = m1.getDeclaringClass();
        Class<?> c2 = m2.getDeclaringClass();
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : m2) : (isSuper2 ? m1 : null);
    }

    public static Class<?> inferSubbest(Class<?> c1, Class<?> c2) {
        boolean isSuper1 = c1.isAssignableFrom(c2);
        boolean isSuper2 = c2.isAssignableFrom(c1);
        return isSuper1 ? (isSuper2 ? null : c2) : (isSuper2 ? c1 : null);
    }

    public static class ReflectionAccessException
    extends RuntimeException {
        private static final long serialVersionUID = 6569605861192432009L;

        public ReflectionAccessException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ReflectionNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 9032835250796708037L;

        public ReflectionNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionNotFoundException(String message) {
            super(message);
        }
    }
}

