/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class Serializers {
    public static <T> T reconstitute(T object) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        return Serializers.reconstitute(object, object.getClass().getClassLoader());
    }

    public static <T> T reconstitute(T object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bais, classLoader);
        try {
            Object object2 = ois.readObject();
            return (T)object2;
        }
        finally {
            Closeables.closeQuietly((Closeable)ois);
        }
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
            super(inputStream);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class<?> clazz = Class.forName(objectStreamClass.getName(), false, this.classLoader);
            if (clazz != null) {
                return clazz;
            }
            return super.resolveClass(objectStreamClass);
        }
    }
}

