/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.math;

public class BitUtils {
    public static byte reverseBitSignificance(byte b) {
        int result = 0;
        int i = 0;
        while (i < 8) {
            result <<= 1;
            if ((b & 1) == 1) {
                ++result;
            }
            b = (byte)(b >> 1);
            ++i;
        }
        return (byte)result;
    }

    public static byte reverseBitSignificanceInByte(int b) {
        return BitUtils.reverseBitSignificance((byte)b);
    }

    public static byte[] reverseBitSignificance(byte ... bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = BitUtils.reverseBitSignificance(bytes[i]);
            ++i;
        }
        return result;
    }

    public static byte[] reverseBitSignificanceInBytes(int ... bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = BitUtils.reverseBitSignificance((byte)bytes[i]);
            ++i;
        }
        return result;
    }

    public static int unsigned(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public static int unsignedByte(int b) {
        if (b < 0) {
            return b % 256 + 256;
        }
        return b % 256;
    }
}

