/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.net;

import brooklyn.util.net.Cidr;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Throwables;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Networking {
    private static final Logger log = LoggerFactory.getLogger(Networking.class);
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final String VALID_IP_ADDRESS_REGEX = "^((0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}(0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    public static final Pattern VALID_IP_ADDRESS_PATTERN = Pattern.compile("^((0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}(0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    public static final List<Cidr> PRIVATE_NETWORKS = Cidr.PRIVATE_NETWORKS_RFC_1918;
    public static InetAddress ANY_NIC = Networking.getInetAddressWithFixedName(0, 0, 0, 0);
    public static InetAddress LOOPBACK = Networking.getInetAddressWithFixedName(127, 0, 0, 1);
    private static boolean loggedLocalhostNotAvailable = false;
    private static boolean triedUnresolvableHostname = false;
    private static String cachedAddressOfUnresolvableHostname = null;

    public static boolean isPortAvailable(int port) {
        try {
            return Networking.isPortAvailable(InetAddress.getByName("localhost"), port);
        }
        catch (UnknownHostException e) {
            if (!loggedLocalhostNotAvailable) {
                loggedLocalhostNotAvailable = true;
                log.warn("localhost unavailable during port availability check for " + port + ": " + e + "; ignoring, but this may be a sign of network misconfiguration");
            }
            return Networking.isPortAvailable(null, port);
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isPortAvailable(InetAddress localAddress, int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        try {
            Socket s = new Socket(localAddress, port);
            try {
                s.close();
            }
            catch (Exception exception) {}
            return false;
        }
        catch (Exception exception) {
            DatagramSocket ds;
            ServerSocket ss;
            block19: {
                ss = null;
                ds = null;
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
                ds = new DatagramSocket(port);
                ds.setReuseAddress(true);
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) break block19;
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
            return true;
            catch (IOException iOException) {
                block20: {
                    try {
                        if (ds != null) {
                            ds.close();
                        }
                        if (ss == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (ds != null) {
                            ds.close();
                        }
                        if (ss != null) {
                            try {
                                ss.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        ss.close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }
        }
    }

    public static int nextAvailablePort(int port) {
        while (!Networking.isPortAvailable(port)) {
            ++port;
        }
        return port;
    }

    public static boolean isPortValid(Integer port) {
        return port != null && port >= 1 && port <= 65535;
    }

    public static int checkPortValid(Integer port, String errorMessage) {
        if (!Networking.isPortValid(port)) {
            throw new IllegalArgumentException("Invalid port value " + port + ": " + errorMessage);
        }
        return port;
    }

    public static void checkPortsValid(Map ports) {
        for (Map.Entry ppo : ports.entrySet()) {
            Map.Entry pp = ppo;
            Object val = pp.getValue();
            if (val == null) {
                throw new IllegalArgumentException("port for " + pp.getKey() + " is null");
            }
            if (!(val instanceof Integer)) {
                throw new IllegalArgumentException("port " + val + " for " + pp.getKey() + " is not an integer (" + val.getClass() + ")");
            }
            Networking.checkPortValid((Integer)val, "" + pp.getKey());
        }
    }

    public static boolean isPrivateSubnet(InetAddress address) {
        return address.isSiteLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress();
    }

    public static synchronized String getAddressOfUnresolvableHostname() {
        if (triedUnresolvableHostname) {
            return cachedAddressOfUnresolvableHostname;
        }
        String h = "noexistent-machine-" + Identifiers.makeRandomBase64Id(8);
        try {
            cachedAddressOfUnresolvableHostname = InetAddress.getByName(h).getHostAddress();
            log.info("NetworkUtils detected " + cachedAddressOfUnresolvableHostname + " being returned by DNS for bogus hostnames (" + h + ")");
        }
        catch (Exception e) {
            log.debug("NetworkUtils detected failure on DNS resolution of unknown hostname (" + h + " throws " + e + ")");
            cachedAddressOfUnresolvableHostname = null;
        }
        triedUnresolvableHostname = true;
        return cachedAddressOfUnresolvableHostname;
    }

    public static InetAddress resolve(String hostname) {
        InetAddress a;
        block9: {
            String ha;
            block8: {
                block7: {
                    try {
                        a = InetAddress.getByName(hostname);
                        if (a != null) break block7;
                        return null;
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("NetworkUtils failed to resolve " + hostname + ", threw " + e);
                        }
                        return null;
                    }
                }
                ha = a.getHostAddress();
                if (log.isDebugEnabled()) {
                    log.debug("NetworkUtils resolved " + hostname + " as " + a);
                }
                if (!ha.equals(Networking.getAddressOfUnresolvableHostname())) break block8;
                return null;
            }
            if (!ha.startsWith("169.")) break block9;
            return null;
        }
        return a;
    }

    public static InetAddress getInetAddressWithFixedName(byte[] ip) {
        try {
            StringBuilder name = new StringBuilder();
            byte[] byArray = ip;
            int n = ip.length;
            int n2 = 0;
            while (n2 < n) {
                byte part = byArray[n2];
                if (name.length() > 0) {
                    name.append(".");
                }
                name.append(part);
                ++n2;
            }
            return InetAddress.getByAddress(name.toString(), ip);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static InetAddress getInetAddressWithFixedName(int ip1, int ip2, int ip3, int ip4) {
        return Networking.getInetAddressWithFixedName(Networking.asByteArray(ip1, ip2, ip3, ip4));
    }

    public static InetAddress getInetAddressWithFixedName(int ip1, int ip2, int ip3, int ip4, int ip5, int ip6) {
        return Networking.getInetAddressWithFixedName(Networking.asByteArray(ip1, ip2, ip3, ip4, ip5, ip6));
    }

    public static byte[] asByteArray(long ... bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = UnsignedBytes.checkedCast((long)bytes[i]);
            ++i;
        }
        return result;
    }

    public static boolean isValidIp4(String input) {
        return VALID_IP_ADDRESS_PATTERN.matcher(input).matches();
    }

    public static InetAddress getInetAddressWithFixedName(String hostnameOrIp) {
        try {
            if (Networking.isValidIp4(hostnameOrIp)) {
                byte[] ip = new byte[4];
                Object[] parts = hostnameOrIp.split("\\.");
                assert (parts.length == 4) : "val=" + hostnameOrIp + "; split=" + Arrays.toString(parts) + "; length=" + parts.length;
                int i = 0;
                while (i < parts.length) {
                    ip[i] = (byte)Integer.parseInt(parts[i]);
                    ++i;
                }
                return InetAddress.getByAddress(hostnameOrIp, ip);
            }
            return InetAddress.getByName(hostnameOrIp);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            InetAddress result = null;
            result = Networking.getInetAddressWithFixedName("127.0.0.1");
            log.warn("Localhost is not resolvable; using " + result);
            return result;
        }
    }

    public static Map<String, InetAddress> getLocalAddresses() {
        Enumeration<NetworkInterface> ne;
        LinkedHashMap<String, InetAddress> result = new LinkedHashMap<String, InetAddress>();
        try {
            ne = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("Local network interfaces are not resolvable: " + e);
            ne = null;
        }
        while (ne != null && ne.hasMoreElements()) {
            NetworkInterface nic = ne.nextElement();
            Enumeration<InetAddress> inets = nic.getInetAddresses();
            while (inets.hasMoreElements()) {
                InetAddress inet = inets.nextElement();
                result.put(inet.getHostAddress(), inet);
            }
        }
        if (result.isEmpty()) {
            log.warn("No local network addresses found; assuming 127.0.0.1");
            InetAddress loop = Cidr.LOOPBACK.addressAtOffset(0);
            result.put(loop.getHostAddress(), loop);
        }
        return result;
    }

    public static Cidr cidr(String cidr) {
        return new Cidr(cidr);
    }

    public static Cidr getPrivateNetwork(String ip) {
        Cidr me = new Cidr(String.valueOf(ip) + "/32");
        for (Cidr c : PRIVATE_NETWORKS) {
            if (!c.contains(me)) continue;
            return c;
        }
        return me;
    }

    public static Cidr getPrivateNetwork(InetAddress address) {
        return Networking.getPrivateNetwork(address.getHostAddress());
    }

    public static boolean isPublicIp(String ipAddress) {
        Cidr me = new Cidr(String.valueOf(ipAddress) + "/32");
        for (Cidr c : Cidr.NON_PUBLIC_CIDRS) {
            if (!c.contains(me)) continue;
            return false;
        }
        return true;
    }
}

