/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.net;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;

public class Urls {
    public static Function<String, URI> stringToUriFunction() {
        return StringToUri.INSTANCE;
    }

    public static Function<String, URL> stringToUrlFunction() {
        return StringToUrl.INSTANCE;
    }

    public static final URL toUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final URL toUrl(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final URI toUri(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return URI.create(uri);
    }

    public static final URI toUri(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean isUrlWithProtocol(String x) {
        if (x == null) {
            return false;
        }
        int i = 0;
        while (i < x.length()) {
            char c = x.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (!Character.isLetter(c)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static String mergePaths(String ... items) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            boolean trimThisMerge;
            String item = stringArray[n2];
            boolean bl = trimThisMerge = result.length() > 0 && !result.toString().endsWith("://") && !result.toString().endsWith(":///") && !result.toString().endsWith(":");
            if (trimThisMerge) {
                while (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
                    result.deleteCharAt(result.length() - 1);
                }
                result.append('/');
            }
            int i = result.length();
            result.append(item);
            if (trimThisMerge) {
                while (result.length() > i && result.charAt(i) == '/') {
                    result.deleteCharAt(i);
                }
            }
            ++n2;
        }
        return result.toString();
    }

    private static enum StringToUri implements Function<String, URI>
    {
        INSTANCE;


        public URI apply(@Nullable String input) {
            return Urls.toUri(input);
        }

        public String toString() {
            return "StringToUri";
        }
    }

    private static enum StringToUrl implements Function<String, URL>
    {
        INSTANCE;


        public URL apply(@Nullable String input) {
            return Urls.toUrl(input);
        }

        public String toString() {
            return "StringToUrl";
        }
    }
}

