/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.ssh;

import brooklyn.util.collections.MutableMap;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommonCommands {
    public static final String INSTALL_TAR = CommonCommands.installExecutable("tar");
    public static final String INSTALL_CURL = CommonCommands.installExecutable("curl");
    public static final String INSTALL_WGET = CommonCommands.installExecutable("wget");
    public static final String INSTALL_ZIP = CommonCommands.installExecutable("zip");

    public static String installExecutable(Map flags, String executable) {
        return CommonCommands.missing(executable, CommonCommands.installPackage(flags, executable));
    }

    public static String installExecutable(String executable) {
        return CommonCommands.installExecutable(new HashMap(), executable);
    }

    public static String quiet(String command) {
        return String.format("(%s > /dev/null 2>&1)", command);
    }

    public static String ok(String command) {
        return String.format("(%s || true)", command);
    }

    public static String sudo(String command) {
        if (command == null) {
            return null;
        }
        return String.format("( if test \"$UID\" -eq 0; then ( %s ); else sudo -E -n -S -- %s; fi )", command, command);
    }

    public static String dontRequireTtyForSudo() {
        return CommonCommands.sudo("sed -i.brooklyn.bak s/.*requiretty.*/#brooklyn-removed-require-tty/ /etc/sudoers");
    }

    public static String on(String osName, String command) {
        return String.format("(grep \"%s\" /etc/issue && %s)", osName, command);
    }

    public static String file(String path, String command) {
        return String.format("(test -f %s && %s)", path, command);
    }

    public static String exists(String executable, String ... commands) {
        String extraCommandsAnded = "";
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c != null) {
                extraCommandsAnded = String.valueOf(extraCommandsAnded) + " && " + c;
            }
            ++n2;
        }
        return String.format("(which %s%s)", executable, extraCommandsAnded);
    }

    public static String missing(String executable, String command) {
        return String.format("(which %s || %s)", executable, command);
    }

    public static String chain(Collection<String> commands) {
        return "(" + CommonCommands.join(commands, " && ") + ")";
    }

    public static String alternatives(Collection<String> commands, String failure) {
        return String.format("(%s || %s)", CommonCommands.join(commands, " || "), failure);
    }

    private static String join(Collection<String> c, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = c.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String formatIfNotNull(String pattern, Object arg) {
        if (arg == null) {
            return null;
        }
        return String.format(pattern, arg);
    }

    public static String installPackage(Map flags, String packageDefaultName) {
        String ifmissing = (String)flags.get("onlyifmissing");
        String aptInstall = CommonCommands.formatIfNotNull("apt-get install -y --allow-unauthenticated %s", CommonCommands.getFlag(flags, "apt", packageDefaultName));
        String yumInstall = CommonCommands.formatIfNotNull("yum -y --nogpgcheck install %s", CommonCommands.getFlag(flags, "yum", packageDefaultName));
        String brewInstall = CommonCommands.formatIfNotNull("brew install %s", CommonCommands.getFlag(flags, "brew", packageDefaultName));
        String portInstall = CommonCommands.formatIfNotNull("port install %s", CommonCommands.getFlag(flags, "port", packageDefaultName));
        LinkedList<String> commands = new LinkedList<String>();
        if (ifmissing != null) {
            commands.add(String.format("which %s", ifmissing));
        }
        commands.add(CommonCommands.exists("apt-get", "echo apt-get exists, doing update", "export DEBIAN_FRONTEND=noninteractive", CommonCommands.sudo("apt-get update"), CommonCommands.sudo(aptInstall)));
        commands.add(CommonCommands.exists("yum", CommonCommands.sudo(yumInstall)));
        commands.add(CommonCommands.exists("brew", brewInstall));
        commands.add(CommonCommands.exists("port", CommonCommands.sudo(portInstall)));
        String failure = String.format("(echo \"WARNING: no known/successful package manager to install %s, may fail subsequently\")", packageDefaultName != null ? packageDefaultName : flags.toString());
        return CommonCommands.alternatives(commands, failure);
    }

    public static String installPackage(String packageDefaultName) {
        return CommonCommands.installPackage(new HashMap(), packageDefaultName);
    }

    public static List<String> downloadUrlAs(String url, String entityVersionPath, String pathlessFilenameToSaveAs) {
        return CommonCommands.downloadUrlAs(new HashMap(), url, entityVersionPath, pathlessFilenameToSaveAs);
    }

    @Deprecated
    public static List<String> downloadUrlAs(Map flags, String url, String entityVersionPath, String pathlessFilenameToSaveAs) {
        ImmutableList urls;
        boolean useLocalRepo;
        Boolean skipLocalRepo = (Boolean)flags.get("skipLocalRepo");
        boolean bl = skipLocalRepo != null ? !skipLocalRepo.booleanValue() : (useLocalRepo = true);
        if (useLocalRepo) {
            String localRepoFileUrl = String.format("file://$HOME/.brooklyn/repository/%s/%s", entityVersionPath, pathlessFilenameToSaveAs);
            urls = ImmutableList.of((Object)localRepoFileUrl, (Object)url);
        } else {
            urls = ImmutableList.of((Object)url);
        }
        return CommonCommands.downloadUrlAs((List<String>)urls, "./" + pathlessFilenameToSaveAs);
    }

    public static List<String> downloadUrlAs(List<String> urls, String saveAs) {
        return Arrays.asList(INSTALL_CURL, String.valueOf(CommonCommands.simpleDownloadUrlAs(urls, saveAs)) + " || exit 9");
    }

    public static String simpleDownloadUrlAs(List<String> urls, String saveAs) {
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("No URLs supplied to download " + saveAs);
        }
        StringBuilder command = new StringBuilder("");
        boolean firsturl = true;
        for (String url : urls) {
            if (!firsturl) {
                command.append(" || ");
            }
            firsturl = false;
            command.append(String.format("curl -f -L \"%s\" -o %s", url, saveAs));
        }
        return command.toString();
    }

    private static Object getFlag(Map flags, String flagName, Object defaultValue) {
        Object found = flags.get(flagName);
        return found == null ? defaultValue : found;
    }

    public static String installJava6() {
        return CommonCommands.installPackage(MutableMap.of("apt", "openjdk-6-jdk", "yum", "java-1.6.0-openjdk-devel"), null);
    }
}

