/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.ssh;

import brooklyn.util.ssh.CommonCommands;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class IptablesCommands {
    public static String cleanUpIptablesRules() {
        return CommonCommands.chain((Collection<String>)ImmutableList.of((Object)CommonCommands.installExecutable("iptables"), (Object)CommonCommands.sudo("iptables -F")));
    }

    public static String insertIptablesRule(Chain chain, String networkInterface, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-I", chain, networkInterface, protocol, port, policy);
    }

    public static String appendIptablesRule(Chain chain, String networkInterface, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-A", chain, networkInterface, protocol, port, policy);
    }

    private static String addIptablesRule(String direction, Chain chain, String networkInterface, Protocol protocol, int port, Policy policy) {
        String addIptablesRule = String.format("iptables %s %s -i %s -p %s --dport %d -j %s", new Object[]{direction, chain, networkInterface, protocol, port, policy});
        return CommonCommands.chain((Collection<String>)ImmutableList.of((Object)CommonCommands.installExecutable("iptables"), (Object)CommonCommands.sudo(addIptablesRule)));
    }

    public static enum Chain {
        INPUT,
        FORWARD,
        OUTPUT;

    }

    public static enum Policy {
        ACCEPT,
        REJECT,
        DROP,
        LOG;

    }

    public static enum Protocol {
        TCP("tcp"),
        UDP("udp"),
        ALL("all");

        final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String toString() {
            return this.protocol;
        }
    }
}

