/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.stream;

import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Streams {
    private static final Logger log = LoggerFactory.getLogger(Streams.class);

    public static void closeQuietly(Closeable x) {
        block2: {
            try {
                x.close();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error closing (ignored) " + x + ": " + e);
            }
        }
    }

    public static InputStream fromString(String input) {
        try {
            byte[] bytes = ((String)Preconditions.checkNotNull((Object)input, (Object)"input")).getBytes(Charsets.UTF_8);
            InputSupplier supplier = ByteStreams.newInputStreamSupplier((byte[])bytes);
            InputStream stream = (InputStream)supplier.getInput();
            return stream;
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Error creating InputStream from String: " + ioe.getMessage());
            }
            throw Exceptions.propagate(ioe);
        }
    }
}

