/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.text.Strings;

public class ByteSizeStrings {
    String suffixBytes = "b";
    String suffixKilo = "kb";
    String suffixMega = "mb";
    String suffixGiga = "gb";
    int bytesPerMetricUnit = 1000;
    int maxLen = 4;
    int precision = 3;

    public String makeSizeString(long size) {
        long t = size;
        if (t == 0L) {
            return "0" + this.suffixBytes;
        }
        if (t < 0L) {
            return "-" + this.makeSizeString(-t);
        }
        long b = t % (long)this.bytesPerMetricUnit;
        long kb = (t /= (long)this.bytesPerMetricUnit) % (long)this.bytesPerMetricUnit;
        long mb = (t /= (long)this.bytesPerMetricUnit) % (long)this.bytesPerMetricUnit;
        long gb = t /= (long)this.bytesPerMetricUnit;
        if (gb > 0L) {
            return String.valueOf(Strings.makeRealString((double)gb + 1.0 * (double)mb / (double)this.bytesPerMetricUnit, this.maxLen, this.precision, 0)) + this.suffixGiga;
        }
        if (mb > 0L) {
            return String.valueOf(Strings.makeRealString((double)mb + 1.0 * (double)kb / (double)this.bytesPerMetricUnit, this.maxLen, this.precision, 0)) + this.suffixMega;
        }
        if (kb > 0L) {
            return String.valueOf(Strings.makeRealString((double)kb + 1.0 * (double)b / (double)this.bytesPerMetricUnit, this.maxLen, this.precision, 0)) + this.suffixKilo;
        }
        return String.valueOf(b) + this.suffixBytes;
    }

    public void setBytesPerMetricUnit(int bytesPerMetricUnit) {
        this.bytesPerMetricUnit = bytesPerMetricUnit;
    }

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setSuffixBytes(String suffixBytes) {
        this.suffixBytes = suffixBytes;
    }

    public void setSuffixGiga(String suffixGiga) {
        this.suffixGiga = suffixGiga;
    }

    public void setSuffixKilo(String suffixKilo) {
        this.suffixKilo = suffixKilo;
    }

    public void setSuffixMega(String suffixMega) {
        this.suffixMega = suffixMega;
    }
}

