/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.net.URLParamEncoder;
import brooklyn.util.text.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class StringEscapes {
    public static boolean isWrappedInDoubleQuotes(String s) {
        if (Strings.isEmpty(s)) {
            return false;
        }
        if (!s.startsWith("\"") || !s.endsWith("\"")) {
            return false;
        }
        return s.substring(1, s.length() - 1).replace("\\\\", "").replace("\\\"", "").indexOf("\"") == -1;
    }

    public static boolean isWrappedInSingleQuotes(String s) {
        if (Strings.isEmpty(s)) {
            return false;
        }
        if (!s.startsWith("'") || !s.endsWith("'")) {
            return false;
        }
        return s.substring(1, s.length() - 1).replace("\\\\", "").replace("\\'", "").indexOf("'") == -1;
    }

    public static boolean isWrappedInMatchingQuotes(String s) {
        return StringEscapes.isWrappedInDoubleQuotes(s) || StringEscapes.isWrappedInSingleQuotes(s);
    }

    public static String escapeUrlParam(String input) {
        return URLParamEncoder.encode(input);
    }

    public static String escapeHtmlFormUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String escapeSql(String x) {
        if (x == null) {
            return null;
        }
        return x.replaceAll("'", "''");
    }

    private static void appendEscaped(Appendable out, char c) throws IOException {
        out.append('\\');
        out.append(c);
    }

    private static String applyUnquoteAndUnescape(String s, String mode, boolean allowMultipleQuotes) {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!quoted) {
                assert (i == 0 || allowMultipleQuotes);
                assert (!escaped);
                if (c == '\"') {
                    quoted = true;
                } else {
                    if (!allowMultipleQuotes) {
                        throw new IllegalArgumentException("String '" + s + "' is not a valid " + mode + " string (must start with double quote)");
                    }
                    result.append(c);
                }
            } else if (escaped) {
                if (c == '\\' || c == '\"' || c == '\'') {
                    result.append(c);
                } else if (c == 'n') {
                    result.append('\n');
                } else if (c == 't') {
                    result.append('\t');
                } else if (c == 'r') {
                    result.append('\r');
                } else {
                    throw new IllegalArgumentException("String '" + s + "' is not a valid " + mode + " string (unsupported escape char '" + c + "' at position " + i + ")");
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                quoted = false;
                if (!allowMultipleQuotes && i < s.length() - 1) {
                    throw new IllegalArgumentException("String '" + s + "' is not a valid " + mode + " string (unescaped interior double quote at position " + i + ")");
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        if (quoted) {
            throw new IllegalArgumentException("String '" + s + "' is not a valid " + mode + " string (unterminated string)");
        }
        assert (!escaped);
        return result.toString();
    }

    public static class BashStringEscapes {
        private static final String BACKSLASH = "\\\\";
        private static final String DOUBLE_QUOTE = "\\\"";

        public static String wrapBash(String value) {
            StringBuilder out = new StringBuilder();
            try {
                BashStringEscapes.wrapBash(value, out);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return out.toString();
        }

        public static void wrapBash(String value, Appendable out) throws IOException {
            out.append('\"');
            BashStringEscapes.escapeLiteralForDoubleQuotedBash(value, out);
            out.append('\"');
        }

        private static void escapeLiteralForDoubleQuotedBash(String value, Appendable out) throws IOException {
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"' || c == '$' || c == '`') {
                    StringEscapes.appendEscaped(out, c);
                } else if (c == '!') {
                    out.append("\"'!'\"");
                } else {
                    out.append(c);
                }
                ++i;
            }
        }

        public static String escapeLiteralForDoubleQuotedBash(String arg) {
            StringBuilder out = new StringBuilder();
            try {
                BashStringEscapes.escapeLiteralForDoubleQuotedBash(arg, out);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return out.toString();
        }

        public static String doubleQuoteLiteralsForBash(String ... args) {
            StringBuilder result = new StringBuilder();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (!Strings.isEmpty(result)) {
                    result.append(" ");
                }
                result.append("\"");
                result.append(BashStringEscapes.escapeLiteralForDoubleQuotedBash(arg));
                result.append("\"");
                ++n2;
            }
            return result.toString();
        }

        public static boolean isValidForDoubleQuotingInBash(String x) {
            return BashStringEscapes.checkValidForDoubleQuotingInBash(x) == null;
        }

        public static void assertValidForDoubleQuotingInBash(String x) {
            String problem = BashStringEscapes.checkValidForDoubleQuotingInBash(x);
            if (problem == null) {
                return;
            }
            throw new IllegalArgumentException("String \"" + x + "\" not acceptable for bash argument (including double quotes): " + problem);
        }

        private static String checkValidForDoubleQuotingInBash(String x) {
            if (x.matches("[^\\\\\\\"]*(\\\\\\\\)*\\\".*")) {
                return "unescaped double quote";
            }
            if (x.matches("[^\\\\\\\\]*(\\\\\\\\)*&.*")) {
                return "unescaped ampersand";
            }
            return null;
        }

        public static String unwrapBashQuotesAndEscapes(String s) {
            return StringEscapes.applyUnquoteAndUnescape(s, "Bash", true);
        }
    }

    public static class JavaStringEscapes {
        public static String escapeJavaString(String value) {
            StringBuilder out = new StringBuilder();
            try {
                JavaStringEscapes.escapeJavaString(value, out);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return out.toString();
        }

        public static String wrapJavaString(String value) {
            StringBuilder out = new StringBuilder();
            try {
                JavaStringEscapes.wrapJavaString(value, out);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return out.toString();
        }

        public static String unwrapJavaStringIfWrapped(String s) {
            if (!StringEscapes.isWrappedInDoubleQuotes(s)) {
                return s;
            }
            return JavaStringEscapes.unwrapJavaString(s);
        }

        public static void wrapJavaString(String value, Appendable out) throws IOException {
            out.append('\"');
            JavaStringEscapes.escapeJavaString(value, out);
            out.append('\"');
        }

        public static void escapeJavaString(String value, Appendable out) throws IOException {
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"' || c == '\'') {
                    StringEscapes.appendEscaped(out, c);
                } else if (c == '\n') {
                    StringEscapes.appendEscaped(out, 'n');
                } else if (c == '\t') {
                    StringEscapes.appendEscaped(out, 't');
                } else if (c == '\r') {
                    StringEscapes.appendEscaped(out, 'r');
                } else {
                    out.append(c);
                }
                ++i;
            }
        }

        public static String unwrapJavaString(String s) {
            return StringEscapes.applyUnquoteAndUnescape(s, "Java", false);
        }

        public static List<String> unwrapQuotedJavaStringList(String s, String separator) {
            ArrayList<String> result = new ArrayList<String>();
            String remaining = s.trim();
            while (remaining.length() > 0) {
                int endIndex = JavaStringEscapes.findNextClosingQuoteOf(remaining);
                result.add(JavaStringEscapes.unwrapJavaString(remaining.substring(0, endIndex + 1)));
                remaining = remaining.substring(endIndex + 1).trim();
                if (remaining.startsWith(separator)) {
                    remaining = remaining.substring(separator.length()).trim();
                    continue;
                }
                if (remaining.length() <= 0) continue;
                throw new IllegalArgumentException("String '" + s + "' has invalid separators, should be '" + separator + "'");
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int findNextClosingQuoteOf(String s) {
            boolean escaped = false;
            boolean quoted = false;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (!quoted) {
                    assert (i == 0);
                    assert (!escaped);
                    if (c != '\"') throw new IllegalArgumentException("String '" + s + "' is not a valid Java string (must start with double quote)");
                    quoted = true;
                } else if (escaped) {
                    escaped = false;
                } else if (c == '\\') {
                    escaped = true;
                } else if (c == '\"') {
                    return i;
                }
                ++i;
            }
            if ($assertionsDisabled || quoted) throw new IllegalArgumentException("String '" + s + "' is not a valid Java string (unterminated string)");
            throw new AssertionError();
        }
    }
}

