/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.text.ByteSizeStrings;
import brooklyn.util.text.FormattedString;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringShortener;
import brooklyn.util.time.Time;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class Strings {
    public static final String VALID_NON_ALPHANUM_FILE_CHARS = "-_.";
    public static final CharMatcher IS_JAVA_IDENTIFIER_PART = CharMatcher.forPredicate((Predicate)new Predicate<Character>(){

        public boolean apply(@Nullable Character input) {
            return input != null && Character.isJavaIdentifierPart(input.charValue());
        }
    });

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(CharSequence s) {
        return Strings.isEmpty(s) || CharMatcher.WHITESPACE.matchesAllOf(s);
    }

    public static boolean isNonEmpty(CharSequence s) {
        return !Strings.isEmpty(s);
    }

    public static boolean isNonBlank(CharSequence s) {
        return !Strings.isBlank(s);
    }

    public static void checkNonEmpty(CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("String must not be empty");
        }
    }

    public static void checkNonEmpty(CharSequence s, String message) {
        if (Strings.isEmpty(s)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static String removeFromEnd(String string, String ... suffixes) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (string.endsWith(suffix)) {
                return string.substring(0, string.length() - suffix.length());
            }
            ++n2;
        }
        return string;
    }

    public static String removeAllFromEnd(String string, String ... suffixes) {
        boolean anotherLoopNeeded = true;
        block0: while (anotherLoopNeeded) {
            if (Strings.isEmpty(string)) {
                return string;
            }
            anotherLoopNeeded = false;
            String[] stringArray = suffixes;
            int n = suffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (string.endsWith(suffix)) {
                    string = string.substring(0, string.length() - suffix.length());
                    anotherLoopNeeded = true;
                    continue block0;
                }
                ++n2;
            }
        }
        return string;
    }

    public static String removeFromStart(String string, String ... prefixes) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (string.startsWith(prefix)) {
                return string.substring(prefix.length());
            }
            ++n2;
        }
        return string;
    }

    public static String removeAllFromStart(String string, String ... prefixes) {
        boolean anotherLoopNeeded = true;
        block0: while (anotherLoopNeeded) {
            if (Strings.isEmpty(string)) {
                return string;
            }
            anotherLoopNeeded = false;
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                if (string.startsWith(prefix)) {
                    string = string.substring(prefix.length());
                    anotherLoopNeeded = true;
                    continue block0;
                }
                ++n2;
            }
        }
        return string;
    }

    public static String join(Iterable<? extends Object> list, String seperator) {
        boolean app = false;
        StringBuilder out = new StringBuilder();
        for (Object object : list) {
            if (app) {
                out.append(seperator);
            }
            out.append(object);
            app = true;
        }
        return out.toString();
    }

    public static String join(Object[] list, String seperator) {
        boolean app = false;
        StringBuilder out = new StringBuilder();
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (app) {
                out.append(seperator);
            }
            out.append(s);
            app = true;
            ++n2;
        }
        return out.toString();
    }

    public static String replaceAll(String source, Map replacements) {
        Iterator iterator = replacements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry rr;
            Map.Entry r = rr = iterator.next();
            source = Strings.replaceAllNonRegex(source, "" + r.getKey(), "" + r.getValue());
        }
        return source;
    }

    public static String replaceAll(String source, String pattern, String replacement) {
        if (source == null) {
            return source;
        }
        StringBuilder result = new StringBuilder(source.length());
        int i = 0;
        while (i < source.length()) {
            if (source.substring(i).startsWith(pattern)) {
                result.append(replacement);
                i += pattern.length();
                continue;
            }
            result.append(source.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static String replaceAllNonRegex(String source, String pattern, String replacement) {
        return Strings.replaceAll(source, pattern, replacement);
    }

    public static String replaceAllRegex(String source, String pattern, String replacement) {
        return source.replaceAll(pattern, replacement);
    }

    public static String makeValidFilename(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"Cannot make valid filename from null string");
        Preconditions.checkArgument((boolean)Strings.isNonBlank(s), (Object)"Cannot make valid filename from blank string");
        return CharMatcher.anyOf((CharSequence)VALID_NON_ALPHANUM_FILE_CHARS).or(CharMatcher.JAVA_LETTER_OR_DIGIT).negate().trimAndCollapseFrom((CharSequence)s, '_');
    }

    public static String makeValidJavaName(String s) {
        if (s == null) {
            return "__null";
        }
        if (s.length() == 0) {
            return "__empty";
        }
        String name = IS_JAVA_IDENTIFIER_PART.negate().collapseFrom((CharSequence)CharMatcher.is((char)'\'').removeFrom((CharSequence)s), '_');
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return "_" + name;
        }
        return name;
    }

    public static String makeValidUniqueJavaName(String s) {
        String name = Strings.makeValidJavaName(s);
        if (Strings.isEmpty(s) || IS_JAVA_IDENTIFIER_PART.matchesAllOf((CharSequence)s) || CharMatcher.is((char)'\'').matchesNoneOf((CharSequence)s)) {
            return name;
        }
        return String.valueOf(name) + "_" + s.hashCode();
    }

    public static String makeRandomId(int l) {
        return Identifiers.makeRandomId(l);
    }

    public static String makeZeroPaddedString(int i, int len) {
        return Strings.makePaddedString("" + i, len, "0", "");
    }

    public static String makePaddedString(String base, int len, String left_pad, String right_pad) {
        String s = base == null ? "" : base;
        while (s.length() < len) {
            s = String.valueOf(left_pad) + s + right_pad;
        }
        return s;
    }

    public static void trimAll(String[] s) {
        int i = 0;
        while (i < s.length) {
            s[i] = s[i] == null ? "" : s[i].trim();
            ++i;
        }
    }

    public static String makeRealString(double x, int maxlen, int prec, int leftPadLen) {
        return Strings.makeRealString(x, maxlen, prec, leftPadLen, 1.0E-11, true);
    }

    public static String makeRealString(double x, int maxlen, int prec, int leftPadLen, double skipDecimalThreshhold, boolean useEForSmallNumbers) {
        String s;
        NumberFormat df = DecimalFormat.getInstance();
        df.setMinimumFractionDigits(0);
        df.setMinimumIntegerDigits(1);
        df.setGroupingUsed(false);
        if (x == 0.0) {
            if (skipDecimalThreshhold > 0.0 || prec <= 1) {
                s = "0";
            } else {
                s = "0.0";
                while (s.length() < prec + 1) {
                    s = String.valueOf(s) + "0";
                }
            }
        } else {
            int numFractionDigits;
            int log = (int)Math.floor(Math.log10(x));
            int n = numFractionDigits = log >= prec ? 0 : prec - log - 1;
            if (numFractionDigits > 0) {
                if (skipDecimalThreshhold > 0.0) {
                    int checkFractionDigits = 0;
                    double multiplier = 1.0;
                    while (checkFractionDigits < numFractionDigits) {
                        if (Math.abs(x - Math.rint(x * multiplier) / multiplier) < skipDecimalThreshhold) break;
                        ++checkFractionDigits;
                        multiplier *= 10.0;
                    }
                    numFractionDigits = checkFractionDigits;
                }
                df.setMinimumFractionDigits(numFractionDigits);
                df.setMaximumFractionDigits(numFractionDigits);
            } else {
                df.setMaximumFractionDigits(0);
            }
            s = df.format(x);
            if (maxlen > 0 && s.length() > maxlen) {
                double signif = x / Math.pow(10.0, log);
                if (s.indexOf(46) >= 0) {
                    if (Math.abs(x) < 1.0 && useEForSmallNumbers) {
                        s = String.valueOf(Strings.makeRealString(signif, -1, prec, -1)) + "E" + log;
                    }
                } else {
                    s = String.valueOf(Strings.makeRealString(signif, -1, prec, -1)) + "E" + log;
                }
            }
        }
        if (leftPadLen > s.length()) {
            return Strings.makePaddedString(s, leftPadLen, " ", "");
        }
        return s;
    }

    public static String makeRealStringNearZero(double x, int maxlen, int prec, int leftPadLen) {
        String s;
        if (Math.abs(x) < 1.0E-10) {
            x = 0.0;
        }
        NumberFormat df = DecimalFormat.getInstance();
        df.setMinimumFractionDigits(0);
        df.setMinimumIntegerDigits(1);
        df.setGroupingUsed(false);
        if (x == 0.0) {
            if (prec <= 1) {
                s = "0";
            } else {
                s = "0.0";
                while (s.length() < prec + 1) {
                    s = String.valueOf(s) + "0";
                }
            }
        } else {
            int scale;
            int log = (int)Math.floor(Math.log10(x));
            int n = scale = log >= prec ? 0 : prec - log - 1;
            if (scale > 0) {
                double scale10 = Math.pow(10.0, scale);
                x = Math.rint(x * scale10) / scale10;
                df.setMinimumFractionDigits(scale);
                df.setMaximumFractionDigits(scale);
            } else {
                df.setMaximumFractionDigits(0);
            }
            s = df.format(x);
            if (maxlen > 0 && s.length() > maxlen) {
                double signif = x / Math.pow(10.0, log);
                if (s.indexOf(46) >= 0) {
                    if (Math.abs(x) < 1.0) {
                        s = String.valueOf(Strings.makeRealString(signif, -1, prec, -1)) + "E" + log;
                    }
                } else {
                    s = String.valueOf(Strings.makeRealString(signif, -1, prec, -1)) + "E" + log;
                }
            }
        }
        if (leftPadLen > s.length()) {
            return Strings.makePaddedString(s, leftPadLen, " ", "");
        }
        return s;
    }

    public static String getLastWord(String s) {
        if (s == null) {
            return null;
        }
        int x = (s = s.trim()).lastIndexOf(32);
        if (x == -1) {
            return s;
        }
        return s.substring(x + 1);
    }

    @Deprecated
    public static String makeTimeString(long utcMillis) {
        return Time.makeTimeStringRounded(utcMillis);
    }

    public static String[] makeArray(String prefix, int count) {
        String[] result = new String[count];
        int len = ("" + count).length();
        int i = 1;
        while (i <= count) {
            result[i - 1] = String.valueOf(prefix) + Strings.makePaddedString("", len, "0", "" + i);
            ++i;
        }
        return result;
    }

    public static String[] combineArrays(String[] ... arrays) {
        int totalLen = 0;
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            if (array != null) {
                totalLen += array.length;
            }
            ++n2;
        }
        String[] result = new String[totalLen];
        int i = 0;
        String[][] stringArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] array = stringArray2[n4];
            if (array != null) {
                String[] stringArray3 = array;
                int n5 = array.length;
                int n6 = 0;
                while (n6 < n5) {
                    String s = stringArray3[n6];
                    result[i++] = s;
                    ++n6;
                }
            }
            ++n4;
        }
        return result;
    }

    public static String toInitialCapOnly(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1).toLowerCase();
    }

    public static String reverse(String name) {
        return new StringBuffer(name).reverse().toString();
    }

    public static boolean isLowerCase(String s) {
        return s.toLowerCase().equals(s);
    }

    public static String makeRepeated(char c, int length) {
        StringBuilder result = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static String trimEnd(String s) {
        return ("a" + s).trim().substring(1);
    }

    public static String maxlen(String s, int maxlen) {
        return s.substring(0, Math.min(s.length(), maxlen));
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static boolean containsLiteralIgnoreCase(CharSequence input, CharSequence fragment) {
        if (input == null) {
            return false;
        }
        if (Strings.isEmpty(fragment)) {
            return true;
        }
        int lastValidStartPos = input.length() - fragment.length();
        char f0u = Character.toUpperCase(fragment.charAt(0));
        char f0l = Character.toLowerCase(fragment.charAt(0));
        int i = 0;
        while (i <= lastValidStartPos) {
            block6: {
                char ii = input.charAt(i);
                if (ii == f0l || ii == f0u) {
                    int j = 1;
                    while (j < fragment.length()) {
                        if (Character.toLowerCase(input.charAt(i + j)) == Character.toLowerCase(fragment.charAt(j))) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLiteral(CharSequence input, CharSequence fragment) {
        if (input == null) {
            return false;
        }
        if (Strings.isEmpty(fragment)) {
            return true;
        }
        int lastValidStartPos = input.length() - fragment.length();
        char f0 = fragment.charAt(0);
        int i = 0;
        while (i <= lastValidStartPos) {
            block6: {
                char ii = input.charAt(i);
                if (ii == f0) {
                    int j = 1;
                    while (j < fragment.length()) {
                        if (input.charAt(i + j) == fragment.charAt(j)) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String makeSizeString(long sizeInBytes) {
        return new ByteSizeStrings().makeSizeString(sizeInBytes);
    }

    public static StringShortener shortener() {
        return new StringShortener();
    }

    public static FormattedString format(String pattern, Object ... args) {
        return new FormattedString(pattern, args);
    }
}

