/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;

public class WildcardGlobs {
    public static boolean isGlobMatched(String globPattern, String targetText) throws InvalidPatternException {
        List<String> patterns = WildcardGlobs.getGlobsAfterBraceExpansion(globPattern);
        for (String p : patterns) {
            if (!WildcardGlobs.isNoBraceGlobMatched(p, targetText)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoBraceGlobMatched(String globPattern, String target) {
        int pi = 0;
        int ti = 0;
        while (pi < globPattern.length() && ti < target.length()) {
            char pc = globPattern.charAt(pi);
            char tc = target.charAt(pi);
            if (pc == '?') {
                ++pi;
                ++ti;
                continue;
            }
            if (pc != '*') {
                if (pc != tc) {
                    return false;
                }
                ++pi;
                ++ti;
                continue;
            }
            String prest = globPattern.substring(pi + 1);
            while (ti <= target.length()) {
                if (WildcardGlobs.isNoBraceGlobMatched(prest, target.substring(ti))) {
                    return true;
                }
                ++ti;
            }
            return false;
        }
        while (pi < globPattern.length() && globPattern.charAt(pi) == '*') {
            ++pi;
        }
        return pi == globPattern.length() && ti == target.length();
    }

    public static List<String> getGlobsAfterBraceExpansion(String pattern) throws InvalidPatternException {
        return WildcardGlobs.getGlobsAfterBraceExpansion(pattern, false, PhraseTreatment.NOT_A_SPECIAL_CHAR, PhraseTreatment.NOT_A_SPECIAL_CHAR);
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> getGlobsAfterBraceExpansion(String pattern, boolean allowNumericRanges, PhraseTreatment quoteTreatment, PhraseTreatment parenthesesTreatment) throws InvalidPatternException {
        patterns = new ArrayList<ExpressionToExpand>();
        result = new ArrayList<String>();
        patterns.add(new ExpressionToExpand("", pattern, ""));
        while (!patterns.isEmpty()) {
            cs = (ExpressionToExpand)patterns.remove(0);
            resultSoFar = new StringBuffer(cs.resultSoFar);
            operatorStack = cs.operatorStack;
            inQuote = operatorStack.contains("\"");
            expanded = false;
            i = 0;
            while (i < cs.todo.length()) {
                block45: {
                    block43: {
                        block44: {
                            if (!WildcardGlobs.$assertionsDisabled && expanded) {
                                throw new AssertionError();
                            }
                            c = cs.todo.charAt(i);
                            v0 = inParen = operatorStack.contains("(") != false && (inQuote == false || operatorStack.lastIndexOf(34) < operatorStack.lastIndexOf(40));
                            if (!inQuote || inParen && parenthesesTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE)) break block43;
                            if (c != '\"') break block44;
                            if (i > 0 && cs.todo.charAt(i - 1) == '\\') {
                                resultSoFar.append(c);
                            } else {
                                resultSoFar.append(c);
                                inQuote = false;
                                if (operatorStack.charAt(operatorStack.length() - 1) != '\"') {
                                    throw new InvalidPatternException("Quoted string contents not valid, after parsing " + resultSoFar);
                                }
                                operatorStack = operatorStack.substring(0, operatorStack.length() - 1);
                            }
                            break block45;
                        }
                        if (!quoteTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE)) break block43;
                        resultSoFar.append(c);
                        break block45;
                    }
                    if (!inParen) ** GOTO lbl-1000
                    if (c == ')') {
                        resultSoFar.append(c);
                        if (operatorStack.charAt(operatorStack.length() - 1) != '(') {
                            throw new InvalidPatternException("Parenthetical contents not valid, after parsing " + resultSoFar);
                        }
                        operatorStack = operatorStack.substring(0, operatorStack.length() - 1);
                    } else if (parenthesesTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE)) {
                        resultSoFar.append(c);
                        if (c == '(') {
                            operatorStack = String.valueOf(operatorStack) + "(";
                        }
                    } else if (c == '\"' && !quoteTreatment.equals((Object)PhraseTreatment.NOT_A_SPECIAL_CHAR)) {
                        resultSoFar.append(c);
                        inQuote = true;
                        operatorStack = String.valueOf(operatorStack) + "\"";
                    } else if (c == '(' && !parenthesesTreatment.equals((Object)PhraseTreatment.NOT_A_SPECIAL_CHAR)) {
                        resultSoFar.append(c);
                        operatorStack = String.valueOf(operatorStack) + "(";
                    } else {
                        if (c == '{') {
                            expanded = true;
                            operatorStackBeforeExpansion = operatorStack;
                            braceStartIndex = i;
                            tokenStartIndex = i + 1;
                            tokens = new ArrayList<String>();
                            operatorStack = String.valueOf(operatorStack) + "{";
                            while (true) {
                                if (++i >= cs.todo.length()) {
                                    throw new InvalidPatternException("Curly brace not closed, parsing '" + cs.todo.substring(braceStartIndex) + "' after " + resultSoFar);
                                }
                                c = cs.todo.charAt(i);
                                v1 = inParen = operatorStack.contains("(") != false && (inQuote == false || operatorStack.lastIndexOf(34) < operatorStack.lastIndexOf(40));
                                if (!(!inQuote || inParen && parenthesesTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE))) {
                                    if (c == '\"') {
                                        if (i > 0 && cs.todo.charAt(i - 1) == '\\') continue;
                                        inQuote = false;
                                        if (operatorStack.charAt(operatorStack.length() - 1) != '\"') {
                                            throw new InvalidPatternException("Quoted string contents not valid, after parsing " + resultSoFar + cs.todo.substring(braceStartIndex, i));
                                        }
                                        operatorStack = operatorStack.substring(0, operatorStack.length() - 1);
                                        continue;
                                    }
                                    if (quoteTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE)) continue;
                                }
                                if (inParen) {
                                    if (c == ')') {
                                        if (operatorStack.charAt(operatorStack.length() - 1) != '(') {
                                            throw new InvalidPatternException("Parenthetical contents not valid, after parsing " + resultSoFar + cs.todo.substring(braceStartIndex, i));
                                        }
                                        operatorStack = operatorStack.substring(0, operatorStack.length() - 1);
                                        continue;
                                    }
                                    if (parenthesesTreatment.equals((Object)PhraseTreatment.INTERIOR_NOT_EXPANDABLE)) {
                                        if (c != '(') continue;
                                        operatorStack = String.valueOf(operatorStack) + "(";
                                        continue;
                                    }
                                }
                                if (c == '\"' && !quoteTreatment.equals((Object)PhraseTreatment.NOT_A_SPECIAL_CHAR)) {
                                    inQuote = true;
                                    operatorStack = String.valueOf(operatorStack) + "\"";
                                    continue;
                                }
                                if (c == '(' && !parenthesesTreatment.equals((Object)PhraseTreatment.NOT_A_SPECIAL_CHAR)) {
                                    operatorStack = String.valueOf(operatorStack) + "(";
                                    continue;
                                }
                                if (c == '}') {
                                    if (operatorStack.charAt(operatorStack.length() - 1) != '{') {
                                        throw new InvalidPatternException("Brace contents not valid, mismatched operators " + operatorStack + " after parsing " + resultSoFar + cs.todo.substring(braceStartIndex, i));
                                    }
                                    if (!(operatorStack = operatorStack.substring(0, operatorStack.length() - 1)).equals(operatorStackBeforeExpansion)) continue;
                                    break;
                                }
                                if (c == ',') {
                                    if (operatorStack.length() != operatorStackBeforeExpansion.length() + 1) continue;
                                    tokens.add(cs.todo.substring(tokenStartIndex, i));
                                    tokenStartIndex = i + 1;
                                    continue;
                                }
                                if (c != '{') continue;
                                operatorStack = String.valueOf(operatorStack) + c;
                            }
                            tokens.add(cs.todo.substring(tokenStartIndex, i));
                            if (!WildcardGlobs.$assertionsDisabled && !operatorStack.equals(operatorStackBeforeExpansion)) {
                                throw new AssertionError();
                            }
                            if (!WildcardGlobs.$assertionsDisabled && cs.todo.charAt(i) != '}') {
                                throw new AssertionError();
                            }
                            if (!WildcardGlobs.$assertionsDisabled && tokens.isEmpty()) {
                                throw new AssertionError();
                            }
                            suffix = cs.todo.substring(i + 1);
                            newPatterns = new ArrayList<ExpressionToExpand>();
                            for (String token : tokens) {
                                if (allowNumericRanges && token.matches("\\s*[0-9]+\\s*-\\s*[0-9]+\\s*")) {
                                    dashIndex = token.indexOf(45);
                                    startS = token.substring(0, dashIndex).trim();
                                    endS = token.substring(dashIndex + 1).trim();
                                    start = Integer.parseInt(startS);
                                    end = Integer.parseInt(endS);
                                    if (startS.startsWith("-")) {
                                        startS = startS.substring(1).trim();
                                    }
                                    if (endS.startsWith("-")) {
                                        endS = endS.substring(1).trim();
                                    }
                                    minLen = Math.min(startS.length(), endS.length());
                                    ti = start;
                                    while (ti <= end) {
                                        tokenI = "" + Math.abs(ti);
                                        while (tokenI.length() < minLen) {
                                            tokenI = "0" + tokenI;
                                        }
                                        if (ti < 0) {
                                            tokenI = "-" + tokenI;
                                        }
                                        newPatterns.add(new ExpressionToExpand(resultSoFar.toString(), String.valueOf(tokenI) + suffix, operatorStackBeforeExpansion));
                                        ++ti;
                                    }
                                    continue;
                                }
                                newPatterns.add(new ExpressionToExpand(resultSoFar.toString(), String.valueOf(token) + suffix, operatorStackBeforeExpansion));
                            }
                            patterns.addAll(0, newPatterns);
                            break;
                        }
                        resultSoFar.append(c);
                    }
                }
                ++i;
            }
            if (expanded) continue;
            if (operatorStack.length() > 0) {
                throw new InvalidPatternException("Unclosed operators " + operatorStack + " parsing " + resultSoFar);
            }
            result.add(resultSoFar.toString());
        }
        if (!WildcardGlobs.$assertionsDisabled && result.isEmpty()) {
            throw new AssertionError();
        }
        return result;
    }

    protected static class ExpressionToExpand {
        String resultSoFar;
        String todo;
        String operatorStack;

        public ExpressionToExpand(String resultSoFar, String todo, String operatorStack) {
            this.resultSoFar = resultSoFar;
            this.todo = todo;
            this.operatorStack = operatorStack;
        }

        public String toString() {
            return "ExpressionToExpand[" + this.todo + ":" + this.resultSoFar + "/" + this.operatorStack + "]";
        }
    }

    public static class InvalidPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -1969068264338310749L;

        public InvalidPatternException(String msg) {
            super(msg);
        }
    }

    public static enum PhraseTreatment {
        NOT_A_SPECIAL_CHAR,
        INTERIOR_EXPANDABLE,
        INTERIOR_NOT_EXPANDABLE;

    }

    public static class SpecialistGlobExpander {
        private boolean expandNumericRanges;
        private PhraseTreatment quoteTreatment;
        private PhraseTreatment parenthesesTreatment;

        public SpecialistGlobExpander(boolean expandNumericRanges, PhraseTreatment quoteTreatment, PhraseTreatment parenthesesTreatment) {
            this.expandNumericRanges = expandNumericRanges;
            this.quoteTreatment = quoteTreatment;
            this.parenthesesTreatment = parenthesesTreatment;
        }

        public List<String> expand(String glob) throws InvalidPatternException {
            return WildcardGlobs.getGlobsAfterBraceExpansion(glob, this.expandNumericRanges, this.quoteTreatment, this.parenthesesTreatment);
        }

        public boolean isGlobMatchedNumeric(String globPattern, String targetText) throws InvalidPatternException {
            List<String> patterns = this.expand(globPattern);
            for (String p : patterns) {
                if (!WildcardGlobs.isNoBraceGlobMatched(p, targetText)) continue;
                return true;
            }
            return false;
        }

        public String[] expandToArrayUnchecked(String glob) {
            try {
                return this.expand(glob).toArray(new String[0]);
            }
            catch (InvalidPatternException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

