/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.time;

import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration> {
    public static final Duration ONE_SECOND = Duration.of(1L, TimeUnit.SECONDS);
    public static final Duration FIVE_SECONDS = Duration.of(5L, TimeUnit.SECONDS);
    public static final Duration TEN_SECONDS = Duration.of(10L, TimeUnit.SECONDS);
    public static final Duration THIRTY_SECONDS = Duration.of(30L, TimeUnit.SECONDS);
    public static final Duration ONE_MINUTE = Duration.of(1L, TimeUnit.MINUTES);
    public static final Duration TWO_MINUTES = Duration.of(2L, TimeUnit.MINUTES);
    public static final Duration FIVE_MINUTES = Duration.of(5L, TimeUnit.MINUTES);
    public static final Duration ONE_HOUR = Duration.of(1L, TimeUnit.HOURS);
    public static final Duration ONE_DAY = Duration.of(1L, TimeUnit.DAYS);
    private final long nanos;

    public Duration(long value, TimeUnit unit) {
        if (value != 0L) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"Cannot accept null timeunit (unless value is 0)");
        } else {
            unit = TimeUnit.MILLISECONDS;
        }
        this.nanos = TimeUnit.NANOSECONDS.convert(value, unit);
    }

    @Override
    public int compareTo(Duration o) {
        return Long.valueOf(this.toNanoseconds()).compareTo(o.toNanoseconds());
    }

    public String toString() {
        return Time.makeTimeStringExact(this);
    }

    public String toStringRounded() {
        return Time.makeTimeStringRounded(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Duration)) {
            return false;
        }
        return this.toMilliseconds() == ((Duration)o).toMilliseconds();
    }

    public int hashCode() {
        return Long.valueOf(this.toMilliseconds()).hashCode();
    }

    public long toUnit(TimeUnit unit) {
        return unit.convert(this.nanos, TimeUnit.NANOSECONDS);
    }

    public long toMilliseconds() {
        return this.toUnit(TimeUnit.MILLISECONDS);
    }

    public long toNanoseconds() {
        return this.nanos;
    }

    public long toSeconds() {
        return this.toUnit(TimeUnit.SECONDS);
    }

    public long nanos() {
        return this.nanos;
    }

    public static Duration parse(String textualDescription) {
        return new Duration(Time.parseTimeString(textualDescription), TimeUnit.MILLISECONDS);
    }

    public static Duration millis(Number n) {
        return new Duration(n.longValue(), TimeUnit.MILLISECONDS);
    }

    public static Duration nanos(Number n) {
        return new Duration(n.longValue(), TimeUnit.NANOSECONDS);
    }

    public static Duration of(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Duration) {
            return (Duration)o;
        }
        if (o instanceof String) {
            return Duration.parse((String)o);
        }
        if (o instanceof Number) {
            return Duration.millis((Number)o);
        }
        try {
            Method millisMethod = o.getClass().getMethod("toMilliseconds", new Class[0]);
            return Duration.millis((Long)millisMethod.invoke(o, new Object[0]));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot convert " + o + " (type " + o.getClass() + ") to a duration");
        }
    }

    public static Duration of(long value, TimeUnit unit) {
        return new Duration(value, unit);
    }

    public Duration add(Duration other) {
        return Duration.nanos(this.nanos() + other.nanos());
    }

    public Duration multiply(long x) {
        return Duration.nanos(this.nanos() * x);
    }

    public Duration times(long x) {
        return this.multiply(x);
    }

    public static void sleep(Duration duration) {
        Time.sleep(duration);
    }
}

