/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.time;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Stopwatch;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class Time {
    public static String DATE_FORMAT_PREFERRED = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_YEAR = 31536000000L;

    public static String makeDateString() {
        return Time.makeDateString(System.currentTimeMillis());
    }

    public static String makeDateString(long date) {
        return new SimpleDateFormat(DATE_FORMAT_PREFERRED).format(new Date(date));
    }

    @Deprecated
    public static String makeTimeString(long t, TimeUnit unit) {
        return Time.makeTimeStringRounded(t, unit);
    }

    public static String makeTimeStringExact(long t, TimeUnit unit) {
        long nanos = unit.toNanos(t);
        return Time.makeTimeStringNanoExact(nanos);
    }

    public static String makeTimeStringRounded(long t, TimeUnit unit) {
        long nanos = unit.toNanos(t);
        return Time.makeTimeStringNanoRounded(nanos);
    }

    public static String makeTimeStringRounded(Stopwatch timer) {
        return Time.makeTimeStringRounded(timer.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public static String makeTimeString(long t) {
        return Time.makeTimeStringRounded(t);
    }

    public static String makeTimeStringExact(long t) {
        return Time.makeTimeString(t, false);
    }

    public static String makeTimeStringRounded(long t) {
        return Time.makeTimeString(t, true);
    }

    public static String makeTimeStringExact(Duration d) {
        return Time.makeTimeStringNanoExact(d.toNanoseconds());
    }

    public static String makeTimeStringRounded(Duration d) {
        return Time.makeTimeStringNanoRounded(d.toNanoseconds());
    }

    public static String makeTimeString(long t, boolean round) {
        return Time.makeTimeStringNano(t * 1000000L, round);
    }

    @Deprecated
    public static String makeTimeStringNano(long tn) {
        return Time.makeTimeStringNanoRounded(tn);
    }

    public static String makeTimeStringNanoExact(long tn) {
        return Time.makeTimeStringNano(tn, false);
    }

    public static String makeTimeStringNanoRounded(long tn) {
        return Time.makeTimeStringNano(tn, true);
    }

    public static String makeTimeStringNano(long tn, boolean round) {
        long tnm = tn % 1000000L;
        long t = tn / 1000000L;
        String result = "";
        long d = t / 86400000L;
        long h = (t %= 86400000L) / 3600000L;
        long m = (t %= 3600000L) / 60000L;
        long s = (t %= 60000L) / 1000L;
        long ms = t %= 1000L;
        int segments = 0;
        if (d > 0L) {
            result = String.valueOf(result) + d + "d ";
            ++segments;
        }
        if (h > 0L) {
            result = String.valueOf(result) + h + "h ";
            ++segments;
        }
        if (round && segments >= 2) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (m > 0L) {
            result = String.valueOf(result) + m + "m ";
            ++segments;
        }
        if (round && (segments >= 2 || d > 0L)) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (s > 0L) {
            if (ms == 0L && tnm == 0L) {
                result = String.valueOf(result) + s + "s";
                ++segments;
                return result;
            }
            if (round && segments > 0) {
                result = String.valueOf(result) + s + "s";
                ++segments;
                return result;
            }
            if (round && s > 10L) {
                result = String.valueOf(result) + Time.toDecimal(s, (double)ms / 1000.0, 1) + "s";
                ++segments;
                return result;
            }
            if (round) {
                result = String.valueOf(result) + Time.toDecimal(s, (double)ms / 1000.0, 2) + "s";
                ++segments;
                return result;
            }
            result = String.valueOf(result) + s + "s ";
        }
        if (round && segments > 0) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (ms > 0L) {
            if (tnm == 0L) {
                result = String.valueOf(result) + ms + "ms";
                ++segments;
                return result;
            }
            if (round && ms >= 100L) {
                result = String.valueOf(result) + Time.toDecimal(ms, (double)tnm / 1000000.0, 1) + "ms";
                ++segments;
                return result;
            }
            if (round && ms >= 10L) {
                result = String.valueOf(result) + Time.toDecimal(ms, (double)tnm / 1000000.0, 2) + "ms";
                ++segments;
                return result;
            }
            if (round) {
                result = String.valueOf(result) + Time.toDecimal(ms, (double)tnm / 1000000.0, 3) + "ms";
                ++segments;
                return result;
            }
            result = String.valueOf(result) + ms + "ms ";
        }
        long us = tnm / 1000L;
        long ns = tnm % 1000L;
        if (us > 0L) {
            if (ns == 0L) {
                result = String.valueOf(result) + us + "us";
                ++segments;
                return result;
            }
            if (round && us >= 100L) {
                result = String.valueOf(result) + Time.toDecimal(us, (double)ns / 1000.0, 1) + "us";
                ++segments;
                return result;
            }
            if (round && us >= 10L) {
                result = String.valueOf(result) + Time.toDecimal(us, (double)ns / 1000.0, 2) + "us";
                ++segments;
                return result;
            }
            if (round) {
                result = String.valueOf(result) + Time.toDecimal(us, (double)ns / 1000.0, 3) + "us";
                ++segments;
                return result;
            }
            result = String.valueOf(result) + us + "us ";
        }
        if (ns > 0L) {
            result = String.valueOf(result) + ns + "ns";
        }
        return Strings.removeAllFromEnd(result, " ");
    }

    private static String toDecimal(long intPart, double fracPart, int decimalPrecision) {
        long powTen = 1L;
        int i = 0;
        while (i < decimalPrecision) {
            powTen *= 10L;
            ++i;
        }
        long fpr = Math.round(fracPart * (double)powTen);
        if (fpr == powTen) {
            ++intPart;
            fpr = 0L;
        }
        return String.valueOf(intPart) + "." + Strings.makePaddedString("" + fpr, decimalPrecision, "0", "");
    }

    @Deprecated
    public static String makeTimeStringNanoLong(long tn) {
        long tnm = tn % 1000000L;
        long t = tn / 1000000L;
        String result = "";
        if (t >= 1000L) {
            long d = t / 1000L / 60L / 60L / 24L;
            long h = t % 86400000L / 1000L / 60L / 60L;
            long m = t % 3600000L / 1000L / 60L;
            long s = t % 60000L / 1000L;
            if (d > 0L) {
                result = String.valueOf(result) + d + "d ";
            }
            if (h > 0L) {
                result = String.valueOf(result) + h + "h ";
            }
            if (m > 0L) {
                result = String.valueOf(result) + m + "m ";
            }
            if (s > 0L) {
                result = String.valueOf(result) + s + "s ";
            }
        }
        result = String.valueOf(result) + t % 1000L + "." + Strings.makePaddedString("" + tnm, 6, "0", "");
        if ((result = String.valueOf(result) + "ms ").endsWith(" ")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static void sleep(Duration duration) {
        Time.sleep(duration.toMilliseconds());
    }

    public static long getTimeOfDayFromUtc(long timeUtc) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTimeInMillis(timeUtc);
        int hour = gregorianCalendar.get(11);
        int min = gregorianCalendar.get(12);
        int sec = gregorianCalendar.get(13);
        int millis = gregorianCalendar.get(14);
        return ((hour * 60 + min) * 60 + sec) * 1000 + millis;
    }

    public static long getTimeUtc(TimeZone zone, int year, int month, int date, int hourOfDay, int minute, int second, int millis) {
        GregorianCalendar time = new GregorianCalendar(zone);
        time.set(year, month, date, hourOfDay, minute, second);
        time.set(14, millis);
        return time.getTimeInMillis();
    }

    public static long roundFromMillis(long millis, TimeUnit units) {
        if (units.compareTo(TimeUnit.MILLISECONDS) > 0) {
            double result = (double)millis / (double)units.toMillis(1L);
            return Math.round(result);
        }
        return units.convert(millis, TimeUnit.MILLISECONDS);
    }

    public static long roundFromMillis(long millis, long millisPerUnit) {
        double result = (double)millis / (double)millisPerUnit;
        return Math.round(result);
    }

    public static long timeRemaining(long startTime, long maxTime) {
        if (maxTime == 0L) {
            return 0L;
        }
        long result = startTime + maxTime - System.currentTimeMillis();
        return result == 0L ? -1L : result;
    }

    public static long parseTimeString(String timeString) {
        return (long)Time.parseTimeStringAsDouble(timeString);
    }

    /*
     * Unable to fully structure code
     */
    public static double parseTimeStringAsDouble(String timeString) {
        if (timeString == null) {
            throw new NumberFormatException("GeneralHelper.parseTimeString cannot parse a null string");
        }
        try {
            d = Double.parseDouble(timeString);
            return d;
        }
        catch (NumberFormatException v0) {
            timeString = timeString.trim();
            s = Strings.getLastWord(timeString).toLowerCase();
            timeString = timeString.substring(0, timeString.length() - s.length()).trim();
            i = 0;
            ** while (s.length() > i)
        }
lbl-1000:
        // 1 sources

        {
            c = s.charAt(i);
            if (c != '.' && !Character.isDigit(c)) break;
            ++i;
            continue;
        }
lbl16:
        // 2 sources

        num = s.substring(0, i);
        if (i == 0) {
            num = Strings.getLastWord(timeString).toLowerCase();
            timeString = timeString.substring(0, timeString.length() - num.length()).trim();
        } else {
            s = s.substring(i);
        }
        multiplier = 0L;
        if (num.length() == 0) {
            if (s.equalsIgnoreCase("never") || s.equalsIgnoreCase("off") || s.equalsIgnoreCase("false")) {
                return -1.0;
            }
            throw new NumberFormatException("unrecognised word  '" + s + "' in time string");
        }
        if (s.equalsIgnoreCase("ms") || s.equalsIgnoreCase("milli") || s.equalsIgnoreCase("millis") || s.equalsIgnoreCase("millisec") || s.equalsIgnoreCase("millisecs") || s.equalsIgnoreCase("millisecond") || s.equalsIgnoreCase("milliseconds")) {
            multiplier = 1L;
        } else if (s.equalsIgnoreCase("s") || s.equalsIgnoreCase("sec") || s.equalsIgnoreCase("secs") || s.equalsIgnoreCase("second") || s.equalsIgnoreCase("seconds")) {
            multiplier = 1000L;
        } else if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("min") || s.equalsIgnoreCase("mins") || s.equalsIgnoreCase("minute") || s.equalsIgnoreCase("minutes")) {
            multiplier = 60000L;
        } else if (s.equalsIgnoreCase("h") || s.equalsIgnoreCase("hr") || s.equalsIgnoreCase("hrs") || s.equalsIgnoreCase("hour") || s.equalsIgnoreCase("hours")) {
            multiplier = 3600000L;
        } else if (s.equalsIgnoreCase("d") || s.equalsIgnoreCase("day") || s.equalsIgnoreCase("days")) {
            multiplier = 86400000L;
        } else {
            throw new NumberFormatException("unknown unit '" + s + "' in time string");
        }
        d = Double.parseDouble(num);
        dd = 0.0;
        if (timeString.length() > 0 && (dd = Time.parseTimeStringAsDouble(timeString)) == -1.0) {
            throw new NumberFormatException("cannot combine '" + timeString + "' with '" + num + " " + s + "'");
        }
        return d * (double)multiplier + dd;
    }

    public static Date dropMilliseconds(Date date) {
        return date == null ? null : (date.getTime() % 1000L != 0L ? new Date(date.getTime() - date.getTime() % 1000L) : date);
    }
}

