/*
 * Decompiled with CFR 0.152.
 */
package io.buoyant.linkerd.tls;

import io.buoyant.linkerd.tls.TlsUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scala.sys.process.package$;

public final class TlsUtils$ {
    public static TlsUtils$ MODULE$;
    private final ProcessLogger DevNull;

    static {
        new TlsUtils$();
    }

    public int run(ProcessBuilder p) {
        return p.$bang(this.DevNull());
    }

    public void withCerts(Seq<String> names, Function1<TlsUtils.Certs, BoxedUnit> f) {
        this.withCertsWithCustomDnsAltNames(names, names, f);
    }

    public void withCertsWithCustomDnsAltNames(Seq<String> names, Seq<String> dnsAltNames, Function1<TlsUtils.Certs, BoxedUnit> f) {
        File tmpdir = new File(new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.stringToProcess("mktemp -d -t linkerd-tls.XXXXXX").$bang$bang())).stripLineEnd());
        try {
            File configFile = this.mkCaDirs(tmpdir);
            if (dnsAltNames != null) {
                this.addDnsAltNamesInConfig(tmpdir, dnsAltNames);
            }
            File caCert = new File(tmpdir, "ca+cert.pem");
            File caKey = new File(tmpdir, "private/ca_key.pem");
            this.assertOk(this.newKeyAndCert("/C=US/CN=Test CA", configFile, caKey, caCert));
            Map svcCerts = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> {
                File routerReq = new File(tmpdir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_req.pem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                File routerCert = new File(tmpdir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_cert.pem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                File routerKey = new File(tmpdir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private/", "_key.tmp.pem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                File routerPk8 = new File(tmpdir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private/", "_pk8.pem"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                this.assertOk(this.newReq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/C=US/CN=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), configFile, routerReq, routerKey));
                this.assertOk(this.signReq(configFile, caKey, caCert, routerReq, routerCert));
                this.assertOk(this.toPk8(routerKey, routerPk8));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)new TlsUtils.ServiceCert(routerCert, routerPk8));
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            f.apply((Object)new TlsUtils.Certs(caCert, (Map<String, TlsUtils.ServiceCert>)svcCerts));
        }
        catch (Throwable throwable) {
            int _ = package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", "-rf", tmpdir.getPath()}))).$bang();
            throw throwable;
        }
        int _ = package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", "-rf", tmpdir.getPath()}))).$bang();
    }

    public void assertOk(ProcessBuilder cmd) {
        Predef$.MODULE$.assert(this.run(cmd) == 0, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "` failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd})));
    }

    public ProcessLogger DevNull() {
        return this.DevNull;
    }

    /*
     * WARNING - void declaration
     */
    public File mkCaDirs(File dir) {
        void var3_3;
        new File(dir, "newcerts").mkdir();
        new File(dir, "private").mkdir();
        new File(dir, "index.txt").createNewFile();
        PrintWriter serial = new PrintWriter(new File(dir, "serial"));
        serial.println("01");
        serial.close();
        File configFile = new File(dir, "openssl.cfg");
        PrintWriter cw = new PrintWriter(configFile);
        cw.print(this.opensslCfg(dir.getPath()));
        cw.close();
        return var3_3;
    }

    public void addDnsAltNamesInConfig(File dir, Seq<String> names) {
        File configFile = new File(dir, "openssl.cfg");
        FileWriter cw = new FileWriter(configFile, true);
        cw.write(this.dnsAltNames(names));
        cw.close();
    }

    public String dnsAltNames(Seq<String> names) {
        Seq altNames = (Seq)((TraversableLike)names.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DNS.", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1)), name}));
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        return altNames.mkString("\n");
    }

    public String opensslCfg(String dir) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    |dir = ", "\n    |\n    |[ ca ]\n    |default_ca = CA_default\n    |\n    |[ CA_default ]\n    |serial = $dir/serial\n    |database = $dir/index.txt\n    |new_certs_dir = $dir/newcerts\n    |certificate  = $dir/cacert.pem\n    |private_key = $dir/private/cakey.pem\n    |default_days = 1\n    |default_md  = sha256\n    |preserve = no\n    |email_in_dn  = no\n    |nameopt = default_ca\n    |certopt = default_ca\n    |policy = policy_match\n    |x509_extensions = x509_extensions\n    |\n    |[ policy_match ]\n    |commonName = supplied\n    |countryName = optional\n    |stateOrProvinceName = optional\n    |organizationName = optional\n    |organizationalUnitName = optional\n    |emailAddress = optional\n    |\n    |[ req ]\n    |default_bits = 2048\n    |default_keyfile = priv.pem\n    |default_md = sha256\n    |distinguished_name = req_distinguished_name\n    |req_extensions = v3_req\n    |encyrpt_key = no\n    |\n    |[ req_distinguished_name ]\n    |\n    |[ v3_ca ]\n    |basicConstraints = CA:TRUE\n    |subjectKeyIdentifier = hash\n    |authorityKeyIdentifier = keyid:always,issuer:always\n    |\n    |[ v3_req ]\n    |basicConstraints = CA:FALSE\n    |subjectKeyIdentifier = hash\n    |\n    |[ x509_extensions ]\n    |subjectAltName = @alt_names\n    |\n    |[alt_names]\n    |URI.1 = https://buoyant.io\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})))).stripMargin();
    }

    public ProcessBuilder newKeyAndCert(String subj, File cfg, File key, File cert) {
        return package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"openssl", "req", "-x509", "-nodes", "-newkey", "rsa:2048", "-config", cfg.getPath(), "-subj", subj, "-keyout", key.getPath(), "-out", cert.getPath()})));
    }

    public ProcessBuilder newReq(String subj, File cfg, File req, File key) {
        return package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"openssl", "req", "-new", "-nodes", "-config", cfg.getPath(), "-subj", subj, "-keyout", key.getPath(), "-out", req.getPath()})));
    }

    public ProcessBuilder signReq(File cfg, File key, File cert, File req, File newCert) {
        return package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"openssl", "ca", "-batch", "-config", cfg.getPath(), "-keyfile", key.getPath(), "-cert", cert.getPath(), "-out", newCert.getPath(), "-infiles", req.getPath()})));
    }

    public ProcessBuilder toPk8(File in, File out) {
        return package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"openssl", "pkcs8", "-topk8", "-nocrypt", "-in", in.getPath(), "-out", out.getPath()})));
    }

    public static final /* synthetic */ void $anonfun$DevNull$1(String x$1) {
    }

    private TlsUtils$() {
        MODULE$ = this;
        this.DevNull = ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> {
            TlsUtils$.$anonfun$DevNull$1(x$1);
            return BoxedUnit.UNIT;
        });
    }
}

