package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BotLocaleProperty {

  def apply(
    nluConfidenceThreshold: Number,
    localeId: String,
    description: Option[String] = None,
    intents: Option[List[_]] = None,
    slotTypes: Option[List[_]] = None,
    voiceSettings: Option[software.amazon.awscdk.services.lex.CfnBot.VoiceSettingsProperty] = None
  ): software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty.Builder)
      .nluConfidenceThreshold(nluConfidenceThreshold)
      .localeId(localeId)
      .description(description.orNull)
      .intents(intents.map(_.asJava).orNull)
      .slotTypes(slotTypes.map(_.asJava).orNull)
      .voiceSettings(voiceSettings.orNull)
      .build()
}
