package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBotAliasProps {

  def apply(
    botAliasName: String,
    botId: String,
    description: Option[String] = None,
    botVersion: Option[String] = None,
    conversationLogSettings: Option[software.amazon.awscdk.services.lex.CfnBotAlias.ConversationLogSettingsProperty] = None,
    sentimentAnalysisSettings: Option[AnyRef] = None,
    botAliasLocaleSettings: Option[List[_]] = None,
    botAliasTags: Option[List[_]] = None
  ): software.amazon.awscdk.services.lex.CfnBotAliasProps =
    (new software.amazon.awscdk.services.lex.CfnBotAliasProps.Builder)
      .botAliasName(botAliasName)
      .botId(botId)
      .description(description.orNull)
      .botVersion(botVersion.orNull)
      .conversationLogSettings(conversationLogSettings.orNull)
      .sentimentAnalysisSettings(sentimentAnalysisSettings.orNull)
      .botAliasLocaleSettings(botAliasLocaleSettings.map(_.asJava).orNull)
      .botAliasTags(botAliasTags.map(_.asJava).orNull)
      .build()
}
