package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MessageGroupProperty {

  def apply(
    message: software.amazon.awscdk.services.lex.CfnBot.MessageProperty,
    variations: Option[List[_]] = None
  ): software.amazon.awscdk.services.lex.CfnBot.MessageGroupProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.MessageGroupProperty.Builder)
      .message(message)
      .variations(variations.map(_.asJava).orNull)
      .build()
}
