package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SlotTypeValueProperty {

  def apply(
    sampleValue: software.amazon.awscdk.services.lex.CfnBot.SampleValueProperty,
    synonyms: Option[List[_]] = None
  ): software.amazon.awscdk.services.lex.CfnBot.SlotTypeValueProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.SlotTypeValueProperty.Builder)
      .sampleValue(sampleValue)
      .synonyms(synonyms.map(_.asJava).orNull)
      .build()
}
