package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailTemplateProps {

  def apply(
    subject: String,
    templateName: String,
    textPart: Option[String] = None,
    templateDescription: Option[String] = None,
    defaultSubstitutions: Option[String] = None,
    htmlPart: Option[String] = None,
    tags: Option[AnyRef] = None
  ): software.amazon.awscdk.services.pinpoint.CfnEmailTemplateProps =
    (new software.amazon.awscdk.services.pinpoint.CfnEmailTemplateProps.Builder)
      .subject(subject)
      .templateName(templateName)
      .textPart(textPart.orNull)
      .templateDescription(templateDescription.orNull)
      .defaultSubstitutions(defaultSubstitutions.orNull)
      .htmlPart(htmlPart.orNull)
      .tags(tags.orNull)
      .build()
}
