/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.authentication.entity;

import java.util.Collections;
import org.springframework.security.core.userdetails.User;

public class CamundaUser
extends User {
    private final Long userKey;
    private final String name;

    public CamundaUser(Long userKey, String name, String username, String password) {
        super(username, password, Collections.emptyList());
        this.userKey = userKey;
        this.name = name;
    }

    public Long getUserKey() {
        return this.userKey;
    }

    public String getName() {
        return this.name;
    }

    public static final class CamundaUserBuilder {
        private Long userKey;
        private String name;
        private String username;
        private String password;

        private CamundaUserBuilder() {
        }

        public static CamundaUserBuilder aCamundaUser() {
            return new CamundaUserBuilder();
        }

        public CamundaUserBuilder withUserKey(Long userKey) {
            this.userKey = userKey;
            return this;
        }

        public CamundaUserBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public CamundaUserBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public CamundaUserBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public CamundaUser build() {
            return new CamundaUser(this.userKey, this.name, this.username, this.password);
        }
    }
}

