/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.AuthorizeUrl;
import com.auth0.IdTokenVerifier;
import com.auth0.IdentityVerificationException;
import com.auth0.InvalidRequestException;
import com.auth0.RandomStorage;
import com.auth0.SessionUtils;
import com.auth0.TokenValidationException;
import com.auth0.Tokens;
import com.auth0.TransientCookieStore;
import com.auth0.client.auth.AuthAPI;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.TokenHolder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;

class RequestProcessor {
    private static final String KEY_STATE = "state";
    private static final String KEY_ERROR = "error";
    private static final String KEY_ERROR_DESCRIPTION = "error_description";
    private static final String KEY_EXPIRES_IN = "expires_in";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_ID_TOKEN = "id_token";
    private static final String KEY_TOKEN_TYPE = "token_type";
    private static final String KEY_CODE = "code";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_RESPONSE_MODE = "response_mode";
    private static final String KEY_FORM_POST = "form_post";
    private static final String KEY_MAX_AGE = "max_age";
    final IdTokenVerifier.Options verifyOptions;
    final boolean useLegacySameSiteCookie;
    private final String responseType;
    private final AuthAPI client;
    private final IdTokenVerifier tokenVerifier;
    private final String organization;
    private final String invitation;
    private final String cookiePath;

    private RequestProcessor(AuthAPI client, String responseType, IdTokenVerifier.Options verifyOptions, IdTokenVerifier tokenVerifier, boolean useLegacySameSiteCookie, String organization, String invitation, String cookiePath) {
        Validate.notNull((Object)client);
        Validate.notNull((Object)responseType);
        Validate.notNull((Object)verifyOptions);
        this.client = client;
        this.responseType = responseType;
        this.verifyOptions = verifyOptions;
        this.tokenVerifier = tokenVerifier;
        this.useLegacySameSiteCookie = useLegacySameSiteCookie;
        this.organization = organization;
        this.invitation = invitation;
        this.cookiePath = cookiePath;
    }

    AuthAPI getClient() {
        return this.client;
    }

    AuthorizeUrl buildAuthorizeUrl(HttpServletRequest request, HttpServletResponse response, String redirectUri, String state, String nonce) {
        AuthorizeUrl creator = new AuthorizeUrl(this.client, request, response, redirectUri, this.responseType).withState(state);
        if (this.organization != null) {
            creator.withOrganization(this.organization);
        }
        if (this.invitation != null) {
            creator.withInvitation(this.invitation);
        }
        if (this.cookiePath != null) {
            creator.withCookiePath(this.cookiePath);
        }
        if (response != null) {
            creator.withLegacySameSiteCookie(this.useLegacySameSiteCookie);
        }
        return this.getAuthorizeUrl(nonce, creator);
    }

    Tokens process(HttpServletRequest request, HttpServletResponse response) throws IdentityVerificationException {
        String nonce;
        this.assertNoError(request);
        this.assertValidState(request, response);
        Tokens frontChannelTokens = this.getFrontChannelTokens(request);
        List<String> responseTypeList = this.getResponseType();
        if (responseTypeList.contains(KEY_ID_TOKEN) && frontChannelTokens.getIdToken() == null) {
            throw new InvalidRequestException("a0.missing_id_token", "ID Token is missing from the response.");
        }
        if (responseTypeList.contains(KEY_TOKEN) && frontChannelTokens.getAccessToken() == null) {
            throw new InvalidRequestException("a0.missing_access_token", "Access Token is missing from the response.");
        }
        if (response != null) {
            nonce = TransientCookieStore.getNonce(request, response);
            if (nonce == null) {
                nonce = RandomStorage.removeSessionNonce(request);
            }
        } else {
            nonce = RandomStorage.removeSessionNonce(request);
        }
        this.verifyOptions.setNonce(nonce);
        return this.getVerifiedTokens(request, frontChannelTokens, responseTypeList);
    }

    static boolean requiresFormPostResponseMode(List<String> responseType) {
        return responseType != null && (responseType.contains(KEY_TOKEN) || responseType.contains(KEY_ID_TOKEN));
    }

    private Tokens getVerifiedTokens(HttpServletRequest request, Tokens frontChannelTokens, List<String> responseTypeList) throws IdentityVerificationException {
        String authorizationCode = request.getParameter(KEY_CODE);
        Tokens codeExchangeTokens = null;
        try {
            if (responseTypeList.contains(KEY_ID_TOKEN)) {
                this.tokenVerifier.verify(frontChannelTokens.getIdToken(), this.verifyOptions);
            }
            if (responseTypeList.contains(KEY_CODE)) {
                String idTokenFromCodeExchange;
                String redirectUri = request.getRequestURL().toString();
                codeExchangeTokens = this.exchangeCodeForTokens(authorizationCode, redirectUri);
                if (!responseTypeList.contains(KEY_ID_TOKEN) && (idTokenFromCodeExchange = codeExchangeTokens.getIdToken()) != null) {
                    this.tokenVerifier.verify(idTokenFromCodeExchange, this.verifyOptions);
                }
            }
        }
        catch (TokenValidationException e) {
            throw new IdentityVerificationException("a0.invalid_jwt_error", "An error occurred while trying to verify the ID Token.", e);
        }
        catch (Auth0Exception e) {
            throw new IdentityVerificationException("a0.api_error", "An error occurred while exchanging the authorization code.", e);
        }
        return this.mergeTokens(frontChannelTokens, codeExchangeTokens);
    }

    List<String> getResponseType() {
        return Arrays.asList(this.responseType.split(" "));
    }

    private AuthorizeUrl getAuthorizeUrl(String nonce, AuthorizeUrl creator) {
        List<String> responseTypeList = this.getResponseType();
        if (responseTypeList.contains(KEY_ID_TOKEN) && nonce != null) {
            creator.withNonce(nonce);
        }
        if (RequestProcessor.requiresFormPostResponseMode(responseTypeList)) {
            creator.withParameter(KEY_RESPONSE_MODE, KEY_FORM_POST);
        }
        if (this.verifyOptions.getMaxAge() != null) {
            creator.withParameter(KEY_MAX_AGE, this.verifyOptions.getMaxAge().toString());
        }
        return creator;
    }

    private Tokens getFrontChannelTokens(HttpServletRequest request) {
        Long expiresIn = request.getParameter(KEY_EXPIRES_IN) == null ? null : Long.valueOf(Long.parseLong(request.getParameter(KEY_EXPIRES_IN)));
        return new Tokens(request.getParameter(KEY_ACCESS_TOKEN), request.getParameter(KEY_ID_TOKEN), null, request.getParameter(KEY_TOKEN_TYPE), expiresIn);
    }

    private void assertNoError(HttpServletRequest request) throws InvalidRequestException {
        String error = request.getParameter(KEY_ERROR);
        if (error != null) {
            String errorDescription = request.getParameter(KEY_ERROR_DESCRIPTION);
            throw new InvalidRequestException(error, errorDescription);
        }
    }

    private void assertValidState(HttpServletRequest request, HttpServletResponse response) throws InvalidRequestException {
        String stateFromRequest = request.getParameter(KEY_STATE);
        if (stateFromRequest == null) {
            throw new InvalidRequestException("a0.invalid_state", "The received state doesn't match the expected one. No state parameter was found on the authorization response.");
        }
        if (response == null) {
            this.checkSessionState(request, stateFromRequest);
            return;
        }
        String cookieState = TransientCookieStore.getState(request, response);
        if (cookieState == null) {
            if (SessionUtils.get(request, "com.auth0.state") == null) {
                throw new InvalidRequestException("a0.invalid_state", "The received state doesn't match the expected one. No state cookie or state session attribute found. Check that you are using non-deprecated methods and that cookies are not being removed on the server.");
            }
            this.checkSessionState(request, stateFromRequest);
            return;
        }
        if (!cookieState.equals(stateFromRequest)) {
            throw new InvalidRequestException("a0.invalid_state", "The received state doesn't match the expected one.");
        }
    }

    private void checkSessionState(HttpServletRequest request, String stateFromRequest) throws InvalidRequestException {
        boolean valid = RandomStorage.checkSessionState(request, stateFromRequest);
        if (!valid) {
            throw new InvalidRequestException("a0.invalid_state", "The received state doesn't match the expected one.");
        }
    }

    private Tokens exchangeCodeForTokens(String authorizationCode, String redirectUri) throws Auth0Exception {
        TokenHolder holder = (TokenHolder)this.client.exchangeCode(authorizationCode, redirectUri).execute();
        return new Tokens(holder.getAccessToken(), holder.getIdToken(), holder.getRefreshToken(), holder.getTokenType(), holder.getExpiresIn());
    }

    private Tokens mergeTokens(Tokens frontChannelTokens, Tokens codeExchangeTokens) {
        Long expiresIn;
        String type;
        String accessToken;
        if (codeExchangeTokens == null) {
            return frontChannelTokens;
        }
        if (codeExchangeTokens.getAccessToken() != null) {
            accessToken = codeExchangeTokens.getAccessToken();
            type = codeExchangeTokens.getType();
            expiresIn = codeExchangeTokens.getExpiresIn();
        } else {
            accessToken = frontChannelTokens.getAccessToken();
            type = frontChannelTokens.getType();
            expiresIn = frontChannelTokens.getExpiresIn();
        }
        String idToken = frontChannelTokens.getIdToken() != null ? frontChannelTokens.getIdToken() : codeExchangeTokens.getIdToken();
        String refreshToken = codeExchangeTokens.getRefreshToken();
        return new Tokens(accessToken, idToken, refreshToken, type, expiresIn);
    }

    static class Builder {
        private final AuthAPI client;
        private final String responseType;
        private final IdTokenVerifier.Options verifyOptions;
        private boolean useLegacySameSiteCookie = true;
        private IdTokenVerifier tokenVerifier;
        private String organization;
        private String invitation;
        private String cookiePath;

        Builder(AuthAPI client, String responseType, IdTokenVerifier.Options verifyOptions) {
            Validate.notNull((Object)client);
            Validate.notNull((Object)responseType);
            Validate.notNull((Object)verifyOptions);
            this.client = client;
            this.responseType = responseType;
            this.verifyOptions = verifyOptions;
        }

        Builder withCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
            return this;
        }

        Builder withLegacySameSiteCookie(boolean useLegacySameSiteCookie) {
            this.useLegacySameSiteCookie = useLegacySameSiteCookie;
            return this;
        }

        Builder withIdTokenVerifier(IdTokenVerifier verifier) {
            this.tokenVerifier = verifier;
            return this;
        }

        Builder withOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        Builder withInvitation(String invitation) {
            this.invitation = invitation;
            return this;
        }

        RequestProcessor build() {
            return new RequestProcessor(this.client, this.responseType, this.verifyOptions, this.tokenVerifier == null ? new IdTokenVerifier() : this.tokenVerifier, this.useLegacySameSiteCookie, this.organization, this.invitation, this.cookiePath);
        }
    }
}

