/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.TokenValidationException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;

abstract class SignatureVerifier {
    private final JWTVerifier verifier;
    private final List<String> acceptedAlgorithms;

    SignatureVerifier(JWTVerifier verifier, String ... algorithm) {
        Validate.notEmpty((Object[])algorithm);
        this.verifier = verifier;
        this.acceptedAlgorithms = Arrays.asList(algorithm);
    }

    private DecodedJWT decodeToken(String token) throws TokenValidationException {
        try {
            return JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new TokenValidationException("ID token could not be decoded", e);
        }
    }

    DecodedJWT verifySignature(String token) throws TokenValidationException {
        DecodedJWT decoded = this.decodeToken(token);
        if (!this.acceptedAlgorithms.contains(decoded.getAlgorithm())) {
            throw new TokenValidationException(String.format("Signature algorithm of \"%s\" is not supported. Expected the ID token to be signed with \"%s\".", decoded.getAlgorithm(), this.acceptedAlgorithms));
        }
        if (this.verifier != null) {
            try {
                this.verifier.verify(decoded);
            }
            catch (SignatureVerificationException e) {
                throw new TokenValidationException("Invalid token signature", e);
            }
            catch (JWTVerificationException jWTVerificationException) {
                // empty catch block
            }
        }
        return decoded;
    }
}

