/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.test;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.spring.client.annotation.processor.ZeebeAnnotationProcessorRegistry;
import io.camunda.zeebe.spring.test.ZeebeTestThreadSupport;
import io.camunda.zeebe.spring.test.proxy.ZeebeClientProxy;
import io.camunda.zeebe.spring.test.proxy.ZeebeTestEngineProxy;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;

public class AbstractZeebeTestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ZeebeClient zeebeClient;

    public void setupWithZeebeEngine(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        ((ZeebeTestEngineProxy)testContext.getApplicationContext().getBean(ZeebeTestEngineProxy.class)).swapZeebeEngine(zeebeEngine);
        BpmnAssert.initRecordStream((RecordStream)RecordStream.of((RecordStreamSource)zeebeEngine.getRecordStreamSource()));
        ZeebeTestThreadSupport.setEngineForCurrentThread(zeebeEngine);
        LOGGER.info("Test engine setup. Now starting deployments and workers...");
        this.zeebeClient = this.createClient(testContext, zeebeEngine);
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).swapZeebeClient(this.zeebeClient);
        ((ZeebeAnnotationProcessorRegistry)testContext.getApplicationContext().getBean(ZeebeAnnotationProcessorRegistry.class)).startAll(this.zeebeClient);
        LOGGER.info("...deployments and workers stated.");
    }

    public ZeebeClient createClient(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().gatewayAddress(zeebeEngine.getGatewayAddress()).usePlaintext();
        if (testContext.getApplicationContext().getBeanNamesForType(JsonMapper.class).length > 0) {
            JsonMapper jsonMapper = (JsonMapper)testContext.getApplicationContext().getBean(JsonMapper.class);
            builder.withJsonMapper(jsonMapper);
        }
        return builder.build();
    }

    public void cleanup(TestContext testContext, ZeebeTestEngine zeebeEngine) {
        if (testContext.getTestException() != null) {
            LOGGER.warn("Test failure on '" + testContext.getTestMethod() + "'. Tracing workflow engine internals on INFO for debugging purposes:");
            RecordStream recordStream = RecordStream.of((RecordStreamSource)zeebeEngine.getRecordStreamSource());
            recordStream.print(true);
            if (recordStream.incidentRecords().iterator().hasNext()) {
                LOGGER.warn("There were incidents in Zeebe during '" + testContext.getTestMethod() + "', maybe they caused some unexpected behavior for you? Please check below:");
                recordStream.incidentRecords().forEach(record -> LOGGER.warn(". " + record.getValue()));
            }
        }
        BpmnAssert.resetRecordStream();
        ZeebeTestThreadSupport.cleanupEngineForCurrentThread();
        ((ZeebeAnnotationProcessorRegistry)testContext.getApplicationContext().getBean(ZeebeAnnotationProcessorRegistry.class)).stopAll(this.zeebeClient);
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).removeZeebeClient();
        this.zeebeClient.close();
        ((ZeebeTestEngineProxy)testContext.getApplicationContext().getBean(ZeebeTestEngineProxy.class)).removeZeebeEngine();
    }
}

