/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.DataGenerator;
import io.camunda.tasklist.data.NameGenerator;
import io.camunda.tasklist.entities.UserEntity;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.UserIndex;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.util.PayloadUtil;
import io.camunda.tasklist.util.ZeebeTestUtil;
import io.camunda.zeebe.client.ZeebeClient;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@DependsOn(value={"tasklistSchemaStartup"})
public abstract class DevDataGeneratorAbstract
implements DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevDataGeneratorAbstract.class);
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    protected UserIndex userIndex;
    protected PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Autowired
    private ZeebeClient zeebeClient;
    @Autowired
    private FormIndex formIndex;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private PayloadUtil payloadUtil;
    private final Random random = new Random();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    private boolean shutdown = false;

    @PostConstruct
    private void startDataGenerator() {
        this.startGeneratingData();
    }

    protected void startGeneratingData() {
        LOGGER.debug("INIT: Generate demo data...");
        try {
            this.createZeebeDataAsync();
        }
        catch (Exception ex) {
            LOGGER.debug("Demo data could not be generated. Cause: {}", (Object)ex.getMessage());
            LOGGER.error("Error occurred when generating demo data.", (Throwable)ex);
        }
    }

    public void createZeebeDataAsync() {
        if (this.shouldCreateData()) {
            this.executor.submit(() -> {
                boolean created = false;
                while (!created && !this.shutdown) {
                    try {
                        this.createDemoUsers();
                        Thread.sleep(10000L);
                        this.createZeebeData();
                        created = true;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Demo data was not generated, will retry", (Throwable)ex);
                    }
                }
            });
        }
    }

    public void createDemoUsers() {
        this.createUser("john", "John", "Doe");
        this.createUser("jane", "Jane", "Doe");
        this.createUser("joe", "Average", "Joe");
        for (int i = 0; i < 5; ++i) {
            String firstname = NameGenerator.getRandomFirstName();
            String lastname = NameGenerator.getRandomLastName();
            this.createUser(firstname + "." + lastname, firstname, lastname);
        }
    }

    protected String userEntityToJSONString(UserEntity aUser) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)aUser);
    }

    private void createZeebeData() {
        this.deployProcesses();
        this.startProcessInstances();
    }

    private void startProcessInstances() {
        int instancesCount = this.random.nextInt(20) + 20;
        for (int i = 0; i < instancesCount; ++i) {
            this.startOrderProcess();
            this.startFlightRegistrationProcess();
            this.startSimpleProcess();
            this.startBigFormProcess();
            this.startCarForRentProcess();
            this.startTwoUserTasks();
        }
    }

    private void startSimpleProcess() {
        Object payload = null;
        int choice = this.random.nextInt(3);
        if (choice == 0) {
            payload = "{\"stringVar\":\"varValue" + this.random.nextInt(100) + "\",  \"intVar\": 123,  \"boolVar\": true,  \"emptyStringVar\": \"\",  \"objectVar\":    {\"testVar\":555, \n   \"testVar2\": \"dkjghkdg\"}}";
        } else if (choice == 1) {
            payload = this.payloadUtil.readJSONStringFromClasspath("/large-payload.json");
        }
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"simpleProcess", (String)payload);
    }

    private void startBigFormProcess() {
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"bigFormProcess", null);
    }

    private void startCarForRentProcess() {
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"registerCarForRent", null);
    }

    private void startTwoUserTasks() {
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"twoUserTasks", null);
    }

    private void startMultipleVersionsProcess() {
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"multipleVersions", null);
    }

    private void startOrderProcess() {
        float price1 = Math.round(this.random.nextFloat() * 100000.0f) / 100;
        float price2 = Math.round(this.random.nextFloat() * 10000.0f) / 100;
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"orderProcess", (String)("{\n  \"clientNo\": \"CNT-1211132-02\",\n  \"orderNo\": \"CMD0001-01\",\n  \"items\": [\n    {\n      \"code\": \"123.135.625\",\n      \"name\": \"Laptop Lenovo ABC-001\",\n      \"quantity\": 1,\n      \"price\": " + Double.valueOf(price1) + "\n    },\n    {\n      \"code\": \"111.653.365\",\n      \"name\": \"Headset Sony QWE-23\",\n      \"quantity\": 2,\n      \"price\": " + Double.valueOf(price2) + "\n    }\n  ],\n  \"mwst\": " + Double.valueOf((double)(price1 + price2) * 0.19) + ",\n  \"total\": " + Double.valueOf(price1 + price2) + ",\n  \"orderStatus\": \"NEW\"\n}"));
    }

    private void startFlightRegistrationProcess() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 5);
        String dueDate = sdf.format(calendar.getTime());
        calendar.add(5, 1);
        String followUpDate = sdf.format(calendar.getTime());
        String payload = "{\"candidateGroups\": [\"group1\", \"group2\"],\"assignee\": \"demo\", \"taskDueDate\" : \"" + dueDate + "\", \"taskFollowUpDate\" : \"" + followUpDate + "\"}";
        ZeebeTestUtil.startProcessInstance((ZeebeClient)this.zeebeClient, (String)"flightRegistration", (String)payload);
    }

    private void deployProcesses() {
        this.zeebeClient.newDeployResourceCommand().addResourceFromClasspath("formDeployedV1.form").send().join();
        this.zeebeClient.newDeployResourceCommand().addResourceFromClasspath("formDeployedV2.form").send().join();
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"startedByLinkedForm.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"formIdProcessDeployed.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"orderProcess.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"registerPassenger.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"simpleProcess.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"bigFormProcess.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"registerCarForRent.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"twoUserTasks.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"multipleVersions.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"multipleVersions-v2.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"subscribeFormProcess.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"startedByFormProcessWithoutPublic.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"travelSearchProcess.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"travelSearchProcess_v2.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"requestAnnualLeave.bpmn"});
        ZeebeTestUtil.deployProcess((ZeebeClient)this.zeebeClient, (String[])new String[]{"two_processes.bpmn"});
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Shutdown DataGenerator");
        this.shutdown = true;
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
            }
        }
    }
}

