/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth.impl;

import com.auth0.jwt.interfaces.Claim;
import io.camunda.zeebe.auth.api.TenantAuthorizationChecker;
import io.camunda.zeebe.auth.impl.JwtAuthorizationDecoder;
import java.util.List;

public class TenantAuthorizationCheckerImpl
implements TenantAuthorizationChecker {
    private final List<String> authorizedTenants;

    public TenantAuthorizationCheckerImpl(List<String> authorizedTenants) {
        this.authorizedTenants = authorizedTenants;
    }

    @Override
    public Boolean isAuthorized(String tenantId) {
        return this.authorizedTenants.contains(tenantId);
    }

    @Override
    public Boolean isFullyAuthorized(List<String> tenantIds) {
        return this.authorizedTenants.containsAll(tenantIds);
    }

    public static TenantAuthorizationChecker fromJwtDecoder(JwtAuthorizationDecoder decoder) {
        List authorizedTenants = ((Claim)decoder.decode().get("authorized_tenants")).asList(String.class);
        return new TenantAuthorizationCheckerImpl(authorizedTenants);
    }
}

