/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.api.NoTopologyAvailableException;
import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class PublishMessageDispatchStrategy
implements RequestDispatchStrategy {
    private final String correlationKey;

    public PublishMessageDispatchStrategy(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public int determinePartition(BrokerTopologyManager topologyManager) {
        BrokerClusterState topology = topologyManager.getTopology();
        if (topology == null || topology.getPartitionsCount() == 0) {
            throw new NoTopologyAvailableException(String.format("Expected to pick partition for message with correlation key '%s', but no topology is available", this.correlationKey));
        }
        int partitionsCount = topology.getPartitionsCount();
        return SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)this.correlationKey), (int)partitionsCount);
    }
}

