/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;

public final class GatewayMetrics {
    private static final Histogram REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("gateway_request_latency")).help("Latency of round-trip from gateway to broker")).labelNames(new String[]{"partition", "requestType"})).register();
    private static final Counter FAILED_REQUESTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("gateway_failed_requests")).help("Number of failed requests")).labelNames(new String[]{"partition", "requestType", "error"})).register();
    private static final Counter TOTAL_REQUESTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("gateway_total_requests")).help("Number of requests")).labelNames(new String[]{"partition", "requestType"})).register();

    private GatewayMetrics() {
    }

    public static void registerSuccessfulRequest(long partition, String requestType, long latencyMs) {
        ((Histogram.Child)REQUEST_LATENCY.labels(new String[]{Long.toString(partition), requestType})).observe((double)((float)latencyMs / 1000.0f));
        ((Counter.Child)TOTAL_REQUESTS.labels(new String[]{Long.toString(partition), requestType})).inc();
    }

    public static void registerFailedRequest(long partition, String requestType, String error) {
        ((Counter.Child)FAILED_REQUESTS.labels(new String[]{Long.toString(partition), requestType, error})).inc();
        ((Counter.Child)TOTAL_REQUESTS.labels(new String[]{Long.toString(partition), requestType})).inc();
    }
}

