/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.MessageHeaderEncoder;
import io.camunda.zeebe.journal.file.SegmentDescriptorEncoder;
import io.camunda.zeebe.journal.file.record.CorruptedLogException;
import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JournalSegmentDescriptorTest {
    JournalSegmentDescriptorTest() {
    }

    @Test
    void shouldWriteAndReadDescriptor() {
        JournalSegmentDescriptor descriptor = JournalSegmentDescriptor.builder().withId(2L).withIndex(100L).withMaxSegmentSize(1024).build();
        ByteBuffer buffer = ByteBuffer.allocate(JournalSegmentDescriptor.getEncodingLength());
        descriptor = descriptor.copyTo(buffer);
        JournalSegmentDescriptor descriptorRead = new JournalSegmentDescriptor(buffer);
        Assertions.assertThat((Object)descriptorRead).isEqualTo((Object)descriptor);
        Assertions.assertThat((long)descriptorRead.id()).isEqualTo(2L);
        Assertions.assertThat((long)descriptorRead.index()).isEqualTo(100L);
        Assertions.assertThat((int)descriptorRead.maxSegmentSize()).isEqualTo(1024);
        Assertions.assertThat((int)descriptorRead.length()).isEqualTo(JournalSegmentDescriptor.getEncodingLength());
    }

    @Test
    void shouldValidateDescriptorHeader() {
        ByteBuffer buffer = ByteBuffer.allocate(JournalSegmentDescriptor.getEncodingLength());
        Assertions.assertThatThrownBy(() -> new JournalSegmentDescriptor(buffer)).isInstanceOf(CorruptedLogException.class);
    }

    @Test
    void shouldReadV1Message() {
        ByteBuffer buffer = ByteBuffer.allocate(JournalSegmentDescriptor.getEncodingLength());
        UnsafeBuffer directBuffer = new UnsafeBuffer(buffer);
        MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
        SegmentDescriptorEncoder descriptorEncoder = new SegmentDescriptorEncoder();
        directBuffer.putByte(0, (byte)1);
        descriptorEncoder.wrapAndApplyHeader((MutableDirectBuffer)directBuffer, 1, headerEncoder).id(123L).index(456L).maxSegmentSize(789);
        JournalSegmentDescriptor descriptor = new JournalSegmentDescriptor(buffer);
        Assertions.assertThat((long)descriptor.id()).isEqualTo(123L);
        Assertions.assertThat((long)descriptor.index()).isEqualTo(456L);
        Assertions.assertThat((int)descriptor.maxSegmentSize()).isEqualTo(789);
    }

    @Test
    void shouldFailWithChecksumMismatch() {
        ByteBuffer buffer = ByteBuffer.allocate(JournalSegmentDescriptor.getEncodingLength());
        JournalSegmentDescriptor descriptor = JournalSegmentDescriptor.builder().withId(123L).withIndex(456L).withMaxSegmentSize(789).build();
        descriptor.copyTo(buffer);
        byte corruptByte = ~buffer.get(buffer.capacity() - 1);
        buffer.put(buffer.capacity() - 1, corruptByte);
        Assertions.assertThatThrownBy(() -> new JournalSegmentDescriptor(buffer)).isInstanceOf(CorruptedLogException.class);
    }
}

