/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.MessageHeaderDecoder;
import io.camunda.zeebe.journal.file.record.JournalRecordReaderUtil;
import io.camunda.zeebe.journal.file.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.file.record.SBESerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LogCorrupter {
    public static boolean corruptRecord(File file, long index) throws IOException {
        int read;
        byte[] bytes = new byte[Math.toIntExact(file.length())];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int available = in.available();
            read = in.read(bytes, 0, bytes.length);
            if (read == -1) {
                read = available;
            }
        }
        if (!LogCorrupter.corruptRecord(bytes, index)) {
            return false;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            out.write(bytes, 0, read);
        }
        return true;
    }

    public static void corruptDescriptor(File file) throws IOException {
        int read;
        byte[] bytes = new byte[JournalSegmentDescriptor.getEncodingLength()];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int available = in.available();
            read = in.read(bytes, 0, bytes.length);
            if (read == -1) {
                read = available;
            }
        }
        byte schemaId = bytes[MessageHeaderDecoder.schemaIdEncodingOffset() + 1];
        bytes[MessageHeaderDecoder.schemaIdEncodingOffset() + 1] = ~schemaId;
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            out.write(bytes, 0, read);
        }
    }

    private static boolean corruptRecord(byte[] bytes, long targetIndex) {
        JournalRecord record;
        JournalRecordReaderUtil reader = new JournalRecordReaderUtil((JournalRecordSerializer)new SBESerializer());
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.position(JournalSegmentDescriptor.getEncodingLength());
        long index = 1L;
        while (FrameUtil.hasValidVersion((ByteBuffer)buffer) && FrameUtil.readVersion((ByteBuffer)buffer) == 1 && (record = reader.read(buffer, index)).index() <= targetIndex) {
            if (record.index() == targetIndex) {
                int lastPos = buffer.position() - 1;
                buffer.put(lastPos, ~buffer.get(lastPos));
                return true;
            }
            ++index;
        }
        return false;
    }
}

