/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalReader;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.FrameUtil;
import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.journal.file.record.RecordData;
import io.camunda.zeebe.journal.file.record.SBESerializer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SegmentedJournalReaderTest {
    private static final int ENTRIES_PER_SEGMENT = 4;
    @TempDir
    Path directory;
    private final DirectBuffer data = new UnsafeBuffer("test".getBytes(StandardCharsets.UTF_8));
    private JournalReader reader;
    private SegmentedJournal journal;

    SegmentedJournalReaderTest() {
    }

    @BeforeEach
    void setup() {
        int entrySize = FrameUtil.getLength() + this.getSerializedSize(this.data);
        this.journal = SegmentedJournal.builder().withDirectory(this.directory.resolve("data").toFile()).withMaxSegmentSize(entrySize * 4 + JournalSegmentDescriptor.getEncodingLength()).withJournalIndexDensity(5).build();
        this.reader = this.journal.openReader();
    }

    @Test
    void shouldReadAfterCompact() {
        for (int i = 1; i <= 20; ++i) {
            Assertions.assertThat((long)this.journal.append((long)i, this.data).index()).isEqualTo((long)i);
        }
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        int indexToCompact = 9;
        this.journal.deleteUntil(9L);
        this.reader.seekToFirst();
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        Assertions.assertThat((long)((JournalRecord)this.reader.next()).index()).isEqualTo(9L);
    }

    @Test
    void shouldSeekToAnyIndexInMultipleSegments() {
        int i;
        long asqn = 1L;
        for (i = 1; i <= 8; ++i) {
            this.journal.append(asqn++, this.data).index();
        }
        for (i = 1; i < 8; ++i) {
            this.reader.seek((long)i);
            Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
            Assertions.assertThat((long)((JournalRecord)this.reader.next()).index()).isEqualTo((long)i);
        }
    }

    @Test
    void shouldSeekToAnyAsqnInMultipleSegments() {
        int i;
        for (i = 1; i <= 8; ++i) {
            this.journal.append((long)i, this.data).index();
        }
        for (i = 1; i <= 8; ++i) {
            this.reader.seekToAsqn((long)i);
            Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
            Assertions.assertThat((long)((JournalRecord)this.reader.next()).asqn()).isEqualTo((long)i);
        }
    }

    @Test
    void shouldNotReadWhenAccessingDeletedSegment() {
        this.journal.append(this.data);
        JournalReader reader = this.journal.openReader();
        this.journal.reset(100L);
        Assertions.assertThat((boolean)reader.hasNext()).isFalse();
    }

    @Test
    void shouldReadAfterReset() {
        this.journal.append(this.data);
        JournalReader reader = this.journal.openReader();
        int resetIndex = 100;
        this.journal.reset(100L);
        this.journal.append(this.data);
        reader.seekToFirst();
        Assertions.assertThat((long)((JournalRecord)reader.next()).index()).isEqualTo(100L);
    }

    private int getSerializedSize(DirectBuffer data) {
        RecordData record = new RecordData(Long.MAX_VALUE, Long.MAX_VALUE, data);
        SBESerializer serializer = new SBESerializer();
        ByteBuffer buffer = ByteBuffer.allocate(128);
        return (Integer)serializer.writeData(record, (MutableDirectBuffer)new UnsafeBuffer(buffer), 0).get() + serializer.getMetadataLength();
    }
}

