/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.IndexInfo;
import io.camunda.zeebe.journal.file.SparseJournalIndex;
import io.camunda.zeebe.journal.file.TestJournalRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SparseJournalIndexTest {
    SparseJournalIndexTest() {
    }

    @Test
    void shouldNotFindIndexWhenNotReachedDensity() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        IndexInfo position = index.lookup(1L);
        Assertions.assertNull((Object)position);
    }

    public static JournalRecord asJournalRecord(long index, long asqn) {
        return new TestJournalRecord(index, asqn, 0L, null);
    }

    @Test
    void shouldFindIndexWhenReachedDensity() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 1L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 2L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 3L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 4L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 5L), 10);
        Assertions.assertEquals((long)5L, (long)index.lookup(5L).index());
        Assertions.assertEquals((int)10, (int)index.lookup(5L).position());
        Assertions.assertEquals((long)5L, (Long)index.lookupAsqn(5L));
    }

    @Test
    void shouldFindLowerIndexWhenNotReachedDensity() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 1L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 2L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 3L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 4L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 5L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 6L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 7L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 8L), 16);
        Assertions.assertEquals((long)5L, (long)index.lookup(8L).index());
        Assertions.assertEquals((int)10, (int)index.lookup(8L).position());
        Assertions.assertEquals((long)5L, (Long)index.lookupAsqn(8L));
    }

    @Test
    void shouldFindNextIndexWhenReachedDensity() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 1L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 2L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 3L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 4L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 5L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 6L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 7L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 8L), 16);
        index.index(SparseJournalIndexTest.asJournalRecord(9L, 9L), 18);
        index.index(SparseJournalIndexTest.asJournalRecord(10L, 10L), 20);
        Assertions.assertEquals((long)10L, (long)index.lookup(10L).index());
        Assertions.assertEquals((int)20, (int)index.lookup(10L).position());
        Assertions.assertEquals((long)10L, (Long)index.lookupAsqn(10L));
    }

    @Test
    void shouldTruncateIndex() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 10L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 20L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 30L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 40L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 50L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 60L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 70L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 80L), 16);
        index.index(SparseJournalIndexTest.asJournalRecord(9L, 90L), 18);
        index.index(SparseJournalIndexTest.asJournalRecord(10L, 100L), 20);
        index.deleteAfter(8L);
        Assertions.assertEquals((long)5L, (long)index.lookup(8L).index());
        Assertions.assertEquals((int)10, (int)index.lookup(8L).position());
        Assertions.assertEquals((long)5L, (long)index.lookup(10L).index());
        Assertions.assertEquals((int)10, (int)index.lookup(10L).position());
        Assertions.assertEquals((long)5L, (Long)index.lookupAsqn(80L));
        Assertions.assertEquals((long)5L, (Long)index.lookupAsqn(90L));
    }

    @Test
    void shouldTruncateCompleteIndex() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 10L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 20L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 30L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 40L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 50L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 60L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 70L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 80L), 16);
        index.index(SparseJournalIndexTest.asJournalRecord(9L, 90L), 18);
        index.index(SparseJournalIndexTest.asJournalRecord(10L, 100L), 20);
        index.deleteAfter(8L);
        index.deleteAfter(4L);
        Assertions.assertNull((Object)index.lookup(4L));
        Assertions.assertNull((Object)index.lookup(5L));
        Assertions.assertNull((Object)index.lookup(8L));
        Assertions.assertNull((Object)index.lookup(10L));
        Assertions.assertNull((Object)index.lookupAsqn(40L));
        Assertions.assertNull((Object)index.lookupAsqn(50L));
        Assertions.assertNull((Object)index.lookupAsqn(80L));
        Assertions.assertNull((Object)index.lookupAsqn(100L));
    }

    @Test
    void shouldNotCompactIndex() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 10L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 20L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 30L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 40L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 50L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 60L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 70L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 80L), 16);
        index.index(SparseJournalIndexTest.asJournalRecord(9L, 90L), 18);
        index.index(SparseJournalIndexTest.asJournalRecord(10L, 100L), 20);
        index.deleteUntil(8L);
        Assertions.assertNull((Object)index.lookup(8L));
        Assertions.assertEquals((long)10L, (long)index.lookup(10L).index());
        Assertions.assertEquals((int)20, (int)index.lookup(10L).position());
    }

    @Test
    void shouldCompactIndex() {
        SparseJournalIndex index = new SparseJournalIndex(5);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 10L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 20L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 30L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 40L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 50L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 60L), 12);
        index.index(SparseJournalIndexTest.asJournalRecord(7L, 70L), 14);
        index.index(SparseJournalIndexTest.asJournalRecord(8L, 80L), 16);
        index.index(SparseJournalIndexTest.asJournalRecord(9L, 90L), 18);
        index.index(SparseJournalIndexTest.asJournalRecord(10L, 100L), 20);
        index.deleteUntil(11L);
        Assertions.assertNull((Object)index.lookup(4L));
        Assertions.assertNull((Object)index.lookup(5L));
        Assertions.assertNull((Object)index.lookup(8L));
        Assertions.assertNull((Object)index.lookupAsqn(40L));
        Assertions.assertNull((Object)index.lookupAsqn(50L));
        Assertions.assertNull((Object)index.lookupAsqn(80L));
    }

    @Test
    void shouldFindAsqnWithInBound() {
        SparseJournalIndex index = new SparseJournalIndex(2);
        index.index(SparseJournalIndexTest.asJournalRecord(1L, 1L), 2);
        index.index(SparseJournalIndexTest.asJournalRecord(2L, 2L), 4);
        index.index(SparseJournalIndexTest.asJournalRecord(3L, 3L), 6);
        index.index(SparseJournalIndexTest.asJournalRecord(4L, 4L), 8);
        index.index(SparseJournalIndexTest.asJournalRecord(5L, 5L), 10);
        index.index(SparseJournalIndexTest.asJournalRecord(6L, 6L), 10);
        Assertions.assertNull((Object)index.lookupAsqn(5L, 1L));
        Assertions.assertEquals((long)2L, (Long)index.lookupAsqn(5L, 3L));
        Assertions.assertEquals((long)2L, (Long)index.lookupAsqn(5L, 3L));
        Assertions.assertEquals((long)4L, (Long)index.lookupAsqn(5L, 4L));
        Assertions.assertEquals((long)4L, (Long)index.lookupAsqn(5L, 5L));
        Assertions.assertEquals((long)4L, (Long)index.lookupAsqn(Long.MAX_VALUE, 5L));
        Assertions.assertEquals((long)6L, (Long)index.lookupAsqn(Long.MAX_VALUE, 6L));
    }
}

