/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file.record;

import io.camunda.zeebe.journal.file.record.CorruptedLogException;
import io.camunda.zeebe.journal.file.record.RecordData;
import io.camunda.zeebe.journal.file.record.RecordMetadata;
import io.camunda.zeebe.journal.file.record.SBESerializer;
import io.camunda.zeebe.util.Either;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SBESerializerTest {
    private RecordData record;
    private RecordMetadata metadata;
    private SBESerializer serializer;
    private MutableDirectBuffer writeBuffer;

    @BeforeEach
    public void setup() {
        this.serializer = new SBESerializer();
        UnsafeBuffer data = new UnsafeBuffer();
        data.wrap("firstData".getBytes());
        this.record = new RecordData(1L, 2L, (DirectBuffer)data);
        this.metadata = new RecordMetadata(1L, 2);
        ByteBuffer buffer = ByteBuffer.allocate(256);
        this.writeBuffer = new UnsafeBuffer(buffer);
    }

    @Test
    public void shouldWriteRecord() {
        Integer recordWrittenLength = (Integer)this.serializer.writeData(this.record, this.writeBuffer, 0).get();
        Assertions.assertThat((Integer)recordWrittenLength).isPositive();
    }

    @Test
    public void shouldReadRecord() {
        Integer length = (Integer)this.serializer.writeData(this.record, this.writeBuffer, 0).get();
        RecordData recordRead = this.serializer.readData((DirectBuffer)this.writeBuffer, 0, length.intValue());
        Assertions.assertThat((long)recordRead.index()).isEqualTo(this.record.index());
        Assertions.assertThat((long)recordRead.asqn()).isEqualTo(this.record.asqn());
        Assertions.assertThat((Comparable)recordRead.data()).isEqualTo((Object)this.record.data());
    }

    @Test
    public void shouldWriteMetadata() {
        int metadataLength = this.serializer.writeMetadata(this.metadata, this.writeBuffer, 0);
        Assertions.assertThat((int)metadataLength).isEqualTo(this.serializer.getMetadataLength());
    }

    @Test
    public void shouldReadMetadata() {
        this.serializer.writeMetadata(this.metadata, this.writeBuffer, 0);
        RecordMetadata metadataRead = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, 0);
        Assertions.assertThat((long)metadataRead.checksum()).isEqualTo(this.metadata.checksum());
        Assertions.assertThat((int)metadataRead.length()).isEqualTo(this.metadata.length());
    }

    @Test
    public void shouldThrowCorruptLogExceptionIfMetadataIsInvalid() {
        this.serializer.writeMetadata(this.metadata, this.writeBuffer, 0);
        this.writeBuffer.putLong(0, 0L);
        Assertions.assertThatThrownBy(() -> this.serializer.readMetadata((DirectBuffer)this.writeBuffer, 0)).isInstanceOf(CorruptedLogException.class);
    }

    @Test
    public void shouldThrowExceptionWhenInvalidRecord() {
        this.writeBuffer.putLong(0, 0L);
        Assertions.assertThatThrownBy(() -> this.serializer.readData((DirectBuffer)this.writeBuffer, 0, 1)).isInstanceOf(CorruptedLogException.class);
    }

    @Test
    public void shouldReadLengthEqualToActualLength() {
        int actualMetadataLength = this.serializer.writeMetadata(this.metadata, this.writeBuffer, 0);
        int readMetadataLength = this.serializer.getMetadataLength((DirectBuffer)this.writeBuffer, 0);
        Assertions.assertThat((int)readMetadataLength).isEqualTo(actualMetadataLength);
    }

    @Test
    public void shouldWriteRecordAtAnyOffset() {
        int offset = 10;
        Integer recordWrittenLength = (Integer)this.serializer.writeData(this.record, this.writeBuffer, 10).get();
        RecordData readData = this.serializer.readData((DirectBuffer)this.writeBuffer, 10, recordWrittenLength.intValue());
        Assertions.assertThat((Object)readData).isEqualTo((Object)this.record);
    }

    @Test
    public void shouldWriteMetadataAtAnyOffset() {
        int offset = 10;
        this.serializer.writeMetadata(this.metadata, this.writeBuffer, 10);
        RecordMetadata readMetadata = this.serializer.readMetadata((DirectBuffer)this.writeBuffer, 10);
        Assertions.assertThat((Object)readMetadata).isEqualTo((Object)this.metadata);
    }

    @Test
    public void shouldThrowBufferOverFlowWhenNotEnoughSpace() {
        int offset = this.writeBuffer.capacity() - 1;
        Assertions.assertThat((Object)this.serializer.writeData(this.record, this.writeBuffer, offset)).matches(Either::isLeft);
    }
}

