/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.file.JournalIndex;
import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.JournalSegmentFile;
import io.camunda.zeebe.journal.file.MappedJournalSegmentReader;
import io.camunda.zeebe.journal.file.MappedJournalSegmentWriter;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import org.agrona.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalSegment
implements AutoCloseable {
    private static final ByteOrder ENDIANNESS = ByteOrder.LITTLE_ENDIAN;
    private static final Logger LOG = LoggerFactory.getLogger(JournalSegment.class);
    private final JournalSegmentFile file;
    private final JournalSegmentDescriptor descriptor;
    private final JournalIndex index;
    private final MappedJournalSegmentWriter writer;
    private final Set<MappedJournalSegmentReader> readers = Sets.newConcurrentHashSet();
    private boolean open = true;
    private final MappedByteBuffer buffer;
    private volatile boolean markedForDeletion = false;

    public JournalSegment(JournalSegmentFile file, JournalSegmentDescriptor descriptor, MappedByteBuffer buffer, long maxWrittenIndex, JournalIndex index) {
        this.file = file;
        this.descriptor = descriptor;
        this.buffer = buffer;
        this.index = index;
        this.writer = this.createWriter(maxWrittenIndex);
    }

    public long id() {
        return this.descriptor.id();
    }

    public long index() {
        return this.descriptor.index();
    }

    public long lastIndex() {
        return this.writer.getLastIndex();
    }

    public JournalSegmentFile file() {
        return this.file;
    }

    public JournalSegmentDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long length() {
        return this.writer.getNextIndex() - this.index();
    }

    public MappedJournalSegmentWriter writer() {
        this.checkOpen();
        return this.writer;
    }

    MappedJournalSegmentReader createReader() {
        this.checkOpen();
        MappedJournalSegmentReader reader = new MappedJournalSegmentReader(this.buffer.asReadOnlyBuffer().position(0).order(ENDIANNESS), this, this.index);
        this.readers.add(reader);
        return reader;
    }

    private MappedJournalSegmentWriter createWriter(long lastWrittenIndex) {
        return new MappedJournalSegmentWriter(this.buffer, this, this.index, lastWrittenIndex);
    }

    void onReaderClosed(MappedJournalSegmentReader reader) {
        this.readers.remove(reader);
        if (this.markedForDeletion && this.readers.isEmpty()) {
            this.safeDelete();
        }
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Segment not open");
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
        this.readers.forEach(MappedJournalSegmentReader::close);
        IoUtil.unmap((MappedByteBuffer)this.buffer);
    }

    public void delete() {
        this.open = false;
        this.markForDeletion();
        if (this.readers.isEmpty()) {
            this.safeDelete();
        }
    }

    private void safeDelete() {
        if (!this.readers.isEmpty()) {
            throw new JournalException(String.format("Cannot delete segment file. There are %d readers referring to this segment.", this.readers.size()));
        }
        try {
            IoUtil.unmap((MappedByteBuffer)this.buffer);
            Files.deleteIfExists(this.file.getFileMarkedForDeletion());
        }
        catch (IOException e) {
            LOG.warn("Could not delete segment {}. File to delete {}. This can lead to increased disk usage.", new Object[]{this, this.file.getFileMarkedForDeletion(), e});
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("index", this.index()).toString();
    }

    private void markForDeletion() {
        if (this.markedForDeletion) {
            return;
        }
        this.writer.close();
        Path target = this.file.getFileMarkedForDeletion();
        try {
            FileUtil.moveDurably((Path)this.file.file().toPath(), (Path)target, (CopyOption[])new CopyOption[0]);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
        this.markedForDeletion = true;
    }
}

