/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.journal.file;

import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class SegmentDescriptorDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "${project.version}";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SegmentDescriptorDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public SegmentDescriptorDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public SegmentDescriptorDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public SegmentDescriptorDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int idId()
    {
        return 1;
    }

    public static int idSinceVersion()
    {
        return 0;
    }

    public static int idEncodingOffset()
    {
        return 0;
    }

    public static int idEncodingLength()
    {
        return 8;
    }

    public static String idMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long idNullValue()
    {
        return -9223372036854775808L;
    }

    public static long idMinValue()
    {
        return -9223372036854775807L;
    }

    public static long idMaxValue()
    {
        return 9223372036854775807L;
    }

    public long id()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int indexId()
    {
        return 2;
    }

    public static int indexSinceVersion()
    {
        return 0;
    }

    public static int indexEncodingOffset()
    {
        return 8;
    }

    public static int indexEncodingLength()
    {
        return 8;
    }

    public static String indexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long indexNullValue()
    {
        return -9223372036854775808L;
    }

    public static long indexMinValue()
    {
        return -9223372036854775807L;
    }

    public static long indexMaxValue()
    {
        return 9223372036854775807L;
    }

    public long index()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int maxSegmentSizeId()
    {
        return 3;
    }

    public static int maxSegmentSizeSinceVersion()
    {
        return 0;
    }

    public static int maxSegmentSizeEncodingOffset()
    {
        return 16;
    }

    public static int maxSegmentSizeEncodingLength()
    {
        return 4;
    }

    public static String maxSegmentSizeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int maxSegmentSizeNullValue()
    {
        return -2147483648;
    }

    public static int maxSegmentSizeMinValue()
    {
        return -2147483647;
    }

    public static int maxSegmentSizeMaxValue()
    {
        return 2147483647;
    }

    public int maxSegmentSize()
    {
        return buffer.getInt(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int lastIndexId()
    {
        return 4;
    }

    public static int lastIndexSinceVersion()
    {
        return 2;
    }

    public static int lastIndexEncodingOffset()
    {
        return 20;
    }

    public static int lastIndexEncodingLength()
    {
        return 8;
    }

    public static String lastIndexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastIndexNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long lastIndexMinValue()
    {
        return 0x0L;
    }

    public static long lastIndexMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long lastIndex()
    {
        if (parentMessage.actingVersion < 2)
        {
            return 0xffffffffffffffffL;
        }

        return buffer.getLong(offset + 20, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int lastPositionId()
    {
        return 5;
    }

    public static int lastPositionSinceVersion()
    {
        return 2;
    }

    public static int lastPositionEncodingOffset()
    {
        return 28;
    }

    public static int lastPositionEncodingLength()
    {
        return 4;
    }

    public static String lastPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastPositionNullValue()
    {
        return 4294967295L;
    }

    public static long lastPositionMinValue()
    {
        return 0L;
    }

    public static long lastPositionMaxValue()
    {
        return 4294967294L;
    }

    public long lastPosition()
    {
        if (parentMessage.actingVersion < 2)
        {
            return 4294967295L;
        }

        return (buffer.getInt(offset + 28, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final SegmentDescriptorDecoder decoder = new SegmentDescriptorDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[SegmentDescriptor](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("id=");
        builder.append(this.id());
        builder.append('|');
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("maxSegmentSize=");
        builder.append(this.maxSegmentSize());
        builder.append('|');
        builder.append("lastIndex=");
        builder.append(this.lastIndex());
        builder.append('|');
        builder.append("lastPosition=");
        builder.append(this.lastPosition());

        limit(originalLimit);

        return builder;
    }
    
    public SegmentDescriptorDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
