/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.journal.file;

import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class SegmentDescriptorEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 7;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "${project.version}";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SegmentDescriptorEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public SegmentDescriptorEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public SegmentDescriptorEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int idId()
    {
        return 1;
    }

    public static int idSinceVersion()
    {
        return 0;
    }

    public static int idEncodingOffset()
    {
        return 0;
    }

    public static int idEncodingLength()
    {
        return 8;
    }

    public static String idMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long idNullValue()
    {
        return -9223372036854775808L;
    }

    public static long idMinValue()
    {
        return -9223372036854775807L;
    }

    public static long idMaxValue()
    {
        return 9223372036854775807L;
    }

    public SegmentDescriptorEncoder id(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int indexId()
    {
        return 2;
    }

    public static int indexSinceVersion()
    {
        return 0;
    }

    public static int indexEncodingOffset()
    {
        return 8;
    }

    public static int indexEncodingLength()
    {
        return 8;
    }

    public static String indexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long indexNullValue()
    {
        return -9223372036854775808L;
    }

    public static long indexMinValue()
    {
        return -9223372036854775807L;
    }

    public static long indexMaxValue()
    {
        return 9223372036854775807L;
    }

    public SegmentDescriptorEncoder index(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int maxSegmentSizeId()
    {
        return 3;
    }

    public static int maxSegmentSizeSinceVersion()
    {
        return 0;
    }

    public static int maxSegmentSizeEncodingOffset()
    {
        return 16;
    }

    public static int maxSegmentSizeEncodingLength()
    {
        return 4;
    }

    public static String maxSegmentSizeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int maxSegmentSizeNullValue()
    {
        return -2147483648;
    }

    public static int maxSegmentSizeMinValue()
    {
        return -2147483647;
    }

    public static int maxSegmentSizeMaxValue()
    {
        return 2147483647;
    }

    public SegmentDescriptorEncoder maxSegmentSize(final int value)
    {
        buffer.putInt(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastIndexId()
    {
        return 4;
    }

    public static int lastIndexSinceVersion()
    {
        return 2;
    }

    public static int lastIndexEncodingOffset()
    {
        return 20;
    }

    public static int lastIndexEncodingLength()
    {
        return 8;
    }

    public static String lastIndexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastIndexNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long lastIndexMinValue()
    {
        return 0x0L;
    }

    public static long lastIndexMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public SegmentDescriptorEncoder lastIndex(final long value)
    {
        buffer.putLong(offset + 20, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastPositionId()
    {
        return 5;
    }

    public static int lastPositionSinceVersion()
    {
        return 2;
    }

    public static int lastPositionEncodingOffset()
    {
        return 28;
    }

    public static int lastPositionEncodingLength()
    {
        return 4;
    }

    public static String lastPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastPositionNullValue()
    {
        return 4294967295L;
    }

    public static long lastPositionMinValue()
    {
        return 0L;
    }

    public static long lastPositionMaxValue()
    {
        return 4294967294L;
    }

    public SegmentDescriptorEncoder lastPosition(final long value)
    {
        buffer.putInt(offset + 28, (int)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final SegmentDescriptorDecoder decoder = new SegmentDescriptorDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
