/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class AppenderMetrics {
    private static final Counter TOTAL_DEFERRED_APPEND_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("deferred_append_count_total")).help("Number of deferred appends due to backpressure")).labelNames(new String[]{"partition"})).register();
    private static final Counter TOTAL_APPEND_TRY_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("try_to_append_total")).help("Number of tries to append")).labelNames(new String[]{"partition"})).register();
    private static final Gauge CURRENT_INFLIGHT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_inflight_append_count")).help("Current number of append inflight")).labelNames(new String[]{"partition"})).register();
    private static final Gauge CURRENT_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_append_limit")).help("Current limit for number of inflight appends")).labelNames(new String[]{"partition"})).register();
    private static final Gauge LAST_COMMITTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_committed_position")).help("The last committed position.")).labelNames(new String[]{"partition"})).register();
    private static final Gauge LAST_WRITTEN_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_appended_position")).help("The last appended position by the appender.")).labelNames(new String[]{"partition"})).register();
    private static final Histogram WRITE_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_append_latency")).help("Latency to append an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private static final Histogram COMMIT_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_commit_latency")).help("Latency to commit an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private final Counter.Child deferredAppends;
    private final Counter.Child triedAppends;
    private final Gauge.Child inflightAppends;
    private final Gauge.Child inflightLimit;
    private final Gauge.Child lastCommitted;
    private final Gauge.Child lastWritten;
    private final Histogram.Child commitLatency;
    private final Histogram.Child appendLatency;

    public AppenderMetrics(int partitionId) {
        String partitionLabel = String.valueOf(partitionId);
        this.deferredAppends = (Counter.Child)TOTAL_DEFERRED_APPEND_COUNT.labels(new String[]{partitionLabel});
        this.triedAppends = (Counter.Child)TOTAL_APPEND_TRY_COUNT.labels(new String[]{partitionLabel});
        this.inflightAppends = (Gauge.Child)CURRENT_INFLIGHT.labels(new String[]{partitionLabel});
        this.inflightLimit = (Gauge.Child)CURRENT_LIMIT.labels(new String[]{partitionLabel});
        this.lastCommitted = (Gauge.Child)LAST_COMMITTED_POSITION.labels(new String[]{partitionLabel});
        this.lastWritten = (Gauge.Child)LAST_WRITTEN_POSITION.labels(new String[]{partitionLabel});
        this.commitLatency = (Histogram.Child)COMMIT_LATENCY.labels(new String[]{partitionLabel});
        this.appendLatency = (Histogram.Child)WRITE_LATENCY.labels(new String[]{partitionLabel});
    }

    public void increaseInflight() {
        this.inflightAppends.inc();
    }

    public void decreaseInflight() {
        this.inflightAppends.dec();
    }

    public void setInflightLimit(long limit) {
        this.inflightLimit.set((double)limit);
    }

    public void increaseTriedAppends() {
        this.triedAppends.inc();
    }

    public void increaseDeferredAppends() {
        this.deferredAppends.inc();
    }

    public Histogram.Timer startWriteTimer() {
        return this.appendLatency.startTimer();
    }

    public Histogram.Timer startCommitTimer() {
        return this.commitLatency.startTimer();
    }

    public void setLastWrittenPosition(long position) {
        this.lastWritten.set((double)position);
    }

    public void setLastCommittedPosition(long position) {
        this.lastCommitted.set((double)position);
    }
}

