/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class SequencerMetrics {
    private static final Gauge QUEUE_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("sequencer_queue_size")).help("Current length of queue, i.e. how many entry batches are available to the appender")).labelNames(new String[]{"partition"})).register();
    private static final Histogram BATCH_SIZE = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("sequencer_batch_size")).help("Histogram over the number of entries in each batch that is appended")).buckets(new double[]{1.0, 2.0, 3.0, 5.0, 10.0, 25.0, 50.0, 100.0, 500.0, 1000.0}).labelNames(new String[]{"partition"})).register();
    private static final Histogram BATCH_LENGTH_BYTES = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("sequencer_batch_length_bytes")).help("Histogram over the size, in Kilobytes, of the sequenced batches")).buckets(new double[]{0.256, 0.512, 1.0, 4.0, 8.0, 32.0, 128.0, 512.0, 1024.0, 4096.0}).labelNames(new String[]{"partition"})).register();
    private final Gauge.Child queueSize;
    private final Histogram.Child batchSize;
    private final Histogram.Child batchLengthBytes;

    SequencerMetrics(int partitionId) {
        String partitionLabel = String.valueOf(partitionId);
        this.queueSize = (Gauge.Child)QUEUE_SIZE.labels(new String[]{partitionLabel});
        this.batchSize = (Histogram.Child)BATCH_SIZE.labels(new String[]{partitionLabel});
        this.batchLengthBytes = (Histogram.Child)BATCH_LENGTH_BYTES.labels(new String[]{partitionLabel});
    }

    void setQueueSize(int length) {
        this.queueSize.set((double)length);
    }

    void observeBatchSize(int size) {
        this.batchSize.observe((double)size);
    }

    void observeBatchLengthBytes(int lengthBytes) {
        int batchLengthKiloBytes = Math.floorDiv(lengthBytes, 1024);
        this.batchLengthBytes.observe((double)batchLengthKiloBytes);
    }
}

