/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;


/**
 * The error code of an error
 */
public enum ErrorCode
{
    INTERNAL_ERROR((short)0),

    PARTITION_LEADER_MISMATCH((short)1),

    UNSUPPORTED_MESSAGE((short)2),

    INVALID_CLIENT_VERSION((short)3),

    MALFORMED_REQUEST((short)4),

    INVALID_MESSAGE_TEMPLATE((short)5),

    INVALID_DEPLOYMENT_PARTITION((short)6),

    PROCESS_NOT_FOUND((short)7),

    RESOURCE_EXHAUSTED((short)8),

    /**
     * To be used to represent an unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    ErrorCode(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ErrorCode get(final short value)
    {
        switch (value)
        {
            case 0: return INTERNAL_ERROR;
            case 1: return PARTITION_LEADER_MISMATCH;
            case 2: return UNSUPPORTED_MESSAGE;
            case 3: return INVALID_CLIENT_VERSION;
            case 4: return MALFORMED_REQUEST;
            case 5: return INVALID_MESSAGE_TEMPLATE;
            case 6: return INVALID_DEPLOYMENT_PARTITION;
            case 7: return PROCESS_NOT_FOUND;
            case 8: return RESOURCE_EXHAUSTED;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
